<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require APPPATH.'libraries/REST_Controller.php';

//require_once APPPATH . 'third_party/vendor/autoload.php';

require_once APPPATH . 'third_party/Twilio/autoload.php'; // ✅ Correct path to SDK

use Twilio\Jwt\AccessToken;
use Twilio\Jwt\Grants\VideoGrant;
use Twilio\Jwt\Grants\ChatGrant;
use Twilio\Jwt\Grants\VoiceGrant;

use Twilio\TwiML\VoiceResponse;


class Api extends REST_Controller {

	protected $client_request = NULL;

	public function __construct()
	{
		parent::__construct();
		date_default_timezone_set("Asia/Kolkata");
		error_reporting(0);
		set_time_limit(0);
			$this->load->database();

		$this->load->model('api/Api_model','user_model');
		//$this->load->library('Notifications');
		$this->load->library('form_validation');
		$this->load->library('auth_token');
	//	$this->load->database();
	

		
		$this->client_request = new stdClass();
		$this->client_request = json_decode(file_get_contents('php://input', true));
		$this->client_request = json_decode(json_encode($this->client_request), true);
	}
	
	
	/* twilio token generation */
	private $twilioAccountSid = 'ACb4cc47cd9a08f21e30f335f6606e1fdd';
    private $twilioApiKey = 'SKf4c8226854a39de85b358333089ea0aa';
    private $twilioApiSecret = 'Vht7anlX06j6OqQCKCFtSACQ1xEJBDII';
    private $twilioChatServiceSid = ''; // Optional

    public function generate_token($user_id) {
        $identity = $user_id;  // e.g., user ID or username

        // Create access token with credentials
        $token = new AccessToken(
            $this->twilioAccountSid,
            $this->twilioApiKey,
            $this->twilioApiSecret,
            3600,
            $identity
        );

        // Grant access to Video
        $videoGrant = new VideoGrant();
        $token->addGrant($videoGrant);

        // Grant access to Chat (optional)
        $chatGrant = new ChatGrant();
        $chatGrant->setServiceSid($this->twilioChatServiceSid);
        $token->addGrant($chatGrant);

        // Return the token as JSON
        // echo json_encode([
        //     'identity' => $identity,
        //     'token' => $token->toJWT()
        // ]);
        return $token->toJWT();
    }
    
    //use Twilio\Jwt\AccessToken;

public function generate_voice_token_post($user_id) {
    $identity = $user_id;
    if (!$identity) {
        return $this->output->set_status_header(400)->set_output('Missing identity');
    }

    $accountSid = 'ACb4cc47cd9a08f21e30f335f6606e1fdd';
    $apiKeySid = 'SKf4c8226854a39de85b358333089ea0aa';
    $apiKeySecret = 'Vht7anlX06j6OqQCKCFtSACQ1xEJBDII';
    $appSid = 'APeaa990404e6d6ccaca4b762225c5ff71'; // TwiML App SID

    $token = new AccessToken($accountSid, $apiKeySid, $apiKeySecret, 3600, $identity);

    $voiceGrant = new VoiceGrant();
    $voiceGrant->setOutgoingApplicationSid($appSid);
    $voiceGrant->setIncomingAllow(true); // ✅ Allow incoming calls
    $token->addGrant($voiceGrant);

    return $token->toJWT();
}


public function generate_voice_token_new_post($user_id) {
    $identity = $user_id;
    if (!$identity) {
        return $this->output->set_status_header(400)->set_output('Missing identity');
    }

    $accountSid = 'ACa9881846dbacb61101968cfd15dd541e';
    $apiKeySid = 'SK721c8eba862ebfde37226e3a20069698';
    $apiKeySecret = 'g6IpJLuqemqAQEbIZ6Tnlv4HM4aHkbwb';
    $appSid = 'APe4a5cb5feb1278d76992bb2ea8f73759'; // TwiML App SID

    $token = new AccessToken($accountSid, $apiKeySid, $apiKeySecret, 3600, $identity);

    $voiceGrant = new VoiceGrant();
    $voiceGrant->setOutgoingApplicationSid($appSid);
    $voiceGrant->setIncomingAllow(true); // ✅ Allow incoming calls
    $token->addGrant($voiceGrant);

    return $token->toJWT();
}


/* twilio token generation */

/* one signal notification */
public function sendNotification_get($playerId, $title, $message, $user_type = null) {
    $appId = '34866b81-82c4-4fec-b39a-95f9ac395de3'; // Replace with your OneSignal App ID
    $apiKey = 'os_v2_app_gsdgxamcyrh6zm42sx42yok54obloqi5dslu435fykdqdy4euwql2se25hapqag2ie7uv34tgji6ln5ez4v37skb7vw3l2el736enli'; // Replace with your OneSignal REST API Key
    
    $curl = curl_init();

    // Common notification data
    $notificationData = [
        "app_id" => $appId,
        "headings" => ["en" => $title], // Notification title
        "contents" => ["en" => $message], // Notification content
        "small_icon" => "no_bg_logo", // Android Small Icon (Place inside res/drawable),
    ];

    // 1️⃣ *Sending to ALL Users*
    if ($playerId === 'all') {
        //$notificationData["included_segments"] = ["All"]; // Send to all users
        $notificationData["filters"] = [
            ["field" => "tag", "key" => "user_type", "relation" => "=", "value" => $user_type]
        ];
    
    // 2️⃣ *Sending to a Filtered User Type (e.g., Only Employees or Only Users)*
    } /*elseif ($userType !== null) {
        
    
    // 3️⃣ *Sending to Multiple Specific Users*
    }*/ elseif (is_array($playerId)) {
        $notificationData["include_player_ids"] = $playerId; // Send to multiple users
    
    // 4️⃣ *Sending to a Single User*
    } else {
        $notificationData["include_player_ids"] = [$playerId]; // Send to a single user
    }

    curl_setopt_array($curl, [
        CURLOPT_URL => "https://onesignal.com/api/v1/notifications",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => json_encode($notificationData),
        CURLOPT_HTTPHEADER => [
            "Authorization: Key $apiKey", // API Key in Authorization header
            "Content-Type: application/json"
        ],
        CURLOPT_SSL_VERIFYPEER => false, // Disable SSL verification for debugging
    ]);

    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);

    if ($err) {
        return "cURL Error: " . $err;
    } else {
        return  $response;
    }
}

/* one signal notification */
	
	/*access token*/
public function getAccessToken(){
    $serviceAccountFile = FCPATH . 'application/libraries/firebase.json'; // Update this path
    $jsonKey = json_decode(file_get_contents($serviceAccountFile), true);

    $header = json_encode(['alg' => 'RS256', 'typ' => 'JWT']);
    $now = time();
    $exp = $now + 3600;

    $payload = json_encode([
        'iss' => $jsonKey['client_email'],
        'sub' => $jsonKey['client_email'],
        'aud' => 'https://oauth2.googleapis.com/token',
        'iat' => $now,
        'exp' => $exp,
        'scope' => 'https://www.googleapis.com/auth/firebase.messaging'
    ]);

    $base64UrlHeader = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($header));
    $base64UrlPayload = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($payload));
    $signature = '';

    $data = $base64UrlHeader . '.' . $base64UrlPayload;
    openssl_sign($data, $signature, $jsonKey['private_key'], 'sha256');

    $base64UrlSignature = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($signature));
    $jwt = $data . '.' . $base64UrlSignature;

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'https://oauth2.googleapis.com/token');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
        'grant_type' => 'urn:ietf:params:oauth:grant-type:jwt-bearer',
        'assertion' => $jwt
    ]));

    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        echo 'Curl error: ' . curl_error($ch);
    }
    curl_close($ch);

    $responseData = json_decode($response, true);
    //print_r($responseData);exit;
    if (isset($responseData['access_token'])) {
        return $responseData['access_token'];
    } else {
        echo 'Error fetching access token: ' . $response;
        return null;
    }
}
/*access token*/

/*sms*/
public function send_otp_sms_post($mobile,$otp){
    $url = "http://sms.hspsms.com/sendSMS?username=uzone&message=Your%20OTP%20is%20$otp%20to%20log%20in%20to%20U%20App.%20Please%20do%20not%20share%20this%20code%20with%20anyone%20-%20U&sendername=UMOVEC&smstype=TRANS&numbers=$mobile&apikey=f67e2331-2b69-4520-a7db-6a8973366e99";
    //echo $url;
    $ch = curl_init(); 
    curl_setopt($ch, CURLOPT_URL, $url); 
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    //curl_setopt($ch, CURLOPT_NOBODY, true);
    curl_exec($ch);
    curl_close($ch);
    return true;
}
/*sms*/

	/*REFERANCE CODE*/
	function referance_post(){
		$response = array('status' => false, 'message' => '', 'response' => array());
		$user_input = $this->client_request;
		extract($user_input);
		if(!$id)
		{
			$response = array('status' => false, 'message' => 'Enter Email ID!', 'response' => array());
			$this->response($response);
		}
		
		
		$this->response($response);
	}
    /*REFERANCE CODE*/
    
    /*token authentication*/
    public function token_get($mobile,$token,$player_id,$app_version)
    {
        $key = "Uappkey";
    	$iat = time(); // current timestamp value
        //$exp = $iat + 60;
        
    	/*$payload = array(
            "iss" => "Issuer of the JWT",
            "aud" => "Audience that the JWT",
            "sub" => "Subject of the JWT",
            "iat" => $iat, //Time the JWT issued at
            //"exp" => $exp, // Expiration time of token
            "email" => 'adi@gmail.com',
        );*/
        
        $payload = array(
            //"id"            => $check_user[0]['id'],
            "phone_number"        => $mobile,
           // "email"         => $check_user[0]['email'],
            "iat"           => $iat, //Time the JWT issued at
            //"exp"           => $exp, // Expiration time of token
        );
              
        $auth_token = $this->auth_token->generateToken($payload,$key,'HS256');
       // echo $token;exit;
      //  $check_user[0]['auth_token'] = $auth_token;
      $check = $this->user_model->common_fetch('users',array('mobile' => $mobile,'delete_status' => 1));
     // echo $check[0]['status'];exit;
      if(empty($check)){
        //   $data = array(
        //       'mobile' => $mobile,
        //   'auth_token'     => $auth_token,
        //   'token'          => $token,
        //   'status'       => 1,
        //   'created_on' => date('Y-m-d H:i:s')
        // );
        // $insert = $this->user_model->common_insert('users',$data);
        // $check = $this->user_model->common_fetch('users',array('id' => $insert,'delete_status' => 1));
        
        
        $response = array('status' => true, 'message' => 'No user with this number.Please register.', 'response' => array('user_details' => array()));
        $this->response($response);
      }else if($check[0]['status'] == 0){
          $response = array('status' => false, 'message' => 'User is In Active.', 'response' => array('user_details' => array()));
        $this->response($response);
      }else{
          $data = array(
           'auth_token'     => $auth_token,
           'token'          => $token,
           'player_id'     => $player_id,
           'app_version'  => $app_version,
          'updated_on' => date('Y-m-d H:i:s')
        );
        $update = $this->user_model->common_update('users',$data,array('mobile' => $mobile,'delete_status' => 1));
        $check = $this->user_model->common_fetch('users',array('mobile' => $mobile,'delete_status' => 1));
        $get_profiles = $this->user_model->get_user_profiles($check[0]['id']);
        $check[0]['profiles'] = $get_profiles['has_data'];
        
         $response = array('status' => true, 'message' => 'User logged in successfully', 'response' => array('user_details' =>$check));
        $this->response($response);
      }
       
    }
    
     public function token_get_registration($id,$token,$player_id)
    {
        $check = $this->user_model->common_fetch('users',array('id' => $id));
        $key = "Uappkey";
    	$iat = time(); // current timestamp value
        //$exp = $iat + 60;
        
    	/*$payload = array(
            "iss" => "Issuer of the JWT",
            "aud" => "Audience that the JWT",
            "sub" => "Subject of the JWT",
            "iat" => $iat, //Time the JWT issued at
            //"exp" => $exp, // Expiration time of token
            "email" => 'adi@gmail.com',
        );*/
        
        $payload = array(
            //"id"            => $check_user[0]['id'],
            "phone_number"        => $check[0]['mobile'],
           // "email"         => $check_user[0]['email'],
            "iat"           => $iat, //Time the JWT issued at
            //"exp"           => $exp, // Expiration time of token
        );
              
        $auth_token = $this->auth_token->generateToken($payload,$key,'HS256');
       // echo $token;exit;
      //  $check_user[0]['auth_token'] = $auth_token;
     // $check = $this->user_model->common_fetch('users',array('mobile' => $mobile,'delete_status' => 1));
      if(empty($check)){
        //   $data = array(
        //       'mobile' => $mobile,
        //   'auth_token'     => $auth_token,
        //   'token'          => $token,
        //   'status'       => 1,
        //   'created_on' => date('Y-m-d H:i:s')
        // );
        // $insert = $this->user_model->common_insert('users',$data);
        // $check = $this->user_model->common_fetch('users',array('id' => $insert,'delete_status' => 1));
        
        
        $response = array('status' => false, 'message' => 'Invalid mobile number.', 'response' => (object)array());
        $this->response($response);
      }else{
          $data = array(
           'auth_token'     => $auth_token,
           'token'          => $token,
           'player_id'     => $player_id,
          'updated_on' => date('Y-m-d H:i:s')
        );
        $update = $this->user_model->common_update('users',$data,array('id' => $id));
        $check = $this->user_model->common_fetch('users',array('id' => $id));
        $get_profiles = $this->user_model->get_user_profiles($id);
        $check[0]['profiles'] = $get_profiles['has_data'];
        
        
        //   $title = "Welcome Message";
        //     $message = "Welcome to U App uniting worlds.";
        //     $user_type = 1;
        //     $member_id = $check_user[0]['player_id'];
        //     $this->sendNotification_get($member_id,$title,$message,$user_type);//exit;
            
     
      
        $response = array('status' => true, 'message' => 'User Registeation successfully', 'response' => array('user_details' =>$check));
        $this->response($response);
      }
    }

    /*token authentication*/

	/*parent login module*/
    public function user_login_post()
    {
        $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($token)){
			$response = array('status' => false, 'message' => 'Token Is Empty', 'response' => (object)array());
            $this->response($response);
		}else if(empty($otp_confirmed)){
			$response = array('status' => false, 'message' => 'OTP Confirm Is Empty', 'response' => (object)array());
            $this->response($response);
		}else{
		    
		    if($otp_confirmed == 'no'){
            $otp = mt_rand(1000, 9999);
            $this->send_otp_sms_post($mobile,$otp);
            $message = "$otp is your OTP for U app login.";
            //$this->send_otp_sms_post($mobile,$otp);
       //  echo  $this->send_otp_sms_post($mobile,$otp);exit;
            // SendSMS($mobile, $message);
            //$message = "Dear user, OTP for Yummazing App is " . $otp . ", please don't share. Valid for 10 mins. Regards, Yummazing Team ";
            //SendSMSSarvi($mobile, $message);
            //$subject = "Sami Grocery-OTP";
            //SendMAIL($email_id, $message, $subject);
            
           
           $response = array('status' => true, 'message' => 'Otp sent successfully!', 'response' => array('otp' => "$otp") );
            $this->response($response);
          
            
        }
        else if($otp_confirmed == 'yes'){
            
     $app_versionq = "";      	
	//	$check_user = $this->user_model->common_fetch('users',array('mobile' => $mobile,'delete_status' => 1));
	if(!empty($app_version)){
	    $app_versionq = $app_version;
	}
		
			  $this->token_get($mobile,$token,$player_id,$app_versionq);
        }
		
	
		}
	}

	/*parent login module*/
	
	/* resend otp*/
	public function resend_otp_post()
    {
        $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
		
	//	$check_user = $this->user_model->common_fetch('users',array('mobile' => $mobile,'delete_status' => 1,'status' => 1));
		//print_r($check_user);
// 			if(empty($check_user[0])){
// 				$response = array('status' => false, 'message' => 'No User With These Details', 'response' => (object)array());
// 				$this->response($response);
// 			}else{
			    
			    
            $otp = mt_rand(1000, 9999);
           $this->send_otp_sms_post($mobile,$otp);
            $message = "$otp is your OTP for U app login.";
            //$this->send_otp_sms_post($mobile,$otp);
       //  echo  $this->send_otp_sms_post($mobile,$otp);exit;
            // SendSMS($mobile, $message);
            //$message = "Dear user, OTP for Yummazing App is " . $otp . ", please don't share. Valid for 10 mins. Regards, Yummazing Team ";
            //SendSMSSarvi($mobile, $message);
            //$subject = "Sami Grocery-OTP";
            //SendMAIL($email_id, $message, $subject);
            
           
           $response = array('status' => true, 'message' => 'Otp sent successfully!', 'response' => array('otp' => "$otp") );
            $this->response($response);
          
            
        
       
		//	}
		}
	}
	
	/* resend otp*/
	
		/*user registartion update*/
	public function user_registration_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($otp_confirmed)){
 			$response = array('status' => false, 'message' => 'OTP Confirm Is Empty', 'response' => (object)array());
            $this->response($response);
 		}

        else if(empty($token)){
			$response = array('status' => false, 'message' => 'Token Is Empty', 'response' => (object)array());
            $this->response($response);
		}
//else if(empty($otp_confirmed)){
// 			$response = array('status' => false, 'message' => 'OTP Confirm Is Empty', 'response' => (object)array());
//             $this->response($response);
// 		}else if(empty($email)){
//             $response = array('status' => false, 'message' => 'Email ID Is Empty', 'response' => array());
//             $this->response($response);
//         }else if(empty($name)){
//             $response = array('status' => false, 'message' => 'name Is Empty', 'response' => array());
//             $this->response($response);
//         }else if(empty($dob)){
//             $response = array('status' => false, 'message' => 'Date of birth Is Empty', 'response' => array());
//             $this->response($response);
//         }else if(empty($gender)){
//             $response = array('status' => false, 'message' => 'Gender Is Empty', 'response' => array());
//             $this->response($response);
//         }else if(empty($from_city)){
//             $response = array('status' => false, 'message' => 'From city Is Empty', 'response' => array());
//             $this->response($response);
//         }else if(empty($stay_city)){
//             $response = array('status' => false, 'message' => 'Stay city Is Empty', 'response' => array());
//             $this->response($response);
//         }else if(empty($latitude)){
//             $response = array('status' => false, 'message' => 'Latitude Is Empty', 'response' => array());
//             $this->response($response);
//         }else if(empty($longitude)){
//             $response = array('status' => false, 'message' => 'Longitude Is Empty', 'response' => array());
//             $this->response($response);
//         }else if(empty($token)){
//             $response = array('status' => false, 'message' => 'Token Is Empty', 'response' => array());
//             $this->response($response);
//         }else{
            
            $check_user = $this->user_model->common_fetch('users',array('mobile' => $mobile,'delete_status' => 1));
            if(!empty($check_user)){
                 $this->token_get($mobile,$token,$player_id);
               // $response = array('status' => false, 'message' => 'Your mobile number already have a account.please login.', 'response' => array());
          //  $this->response($response);
            }else{
                
            
            
               if($otp_confirmed == 'no'){
            $otp = mt_rand(1000, 9999);
           $this->send_otp_sms_post($mobile,$otp);
            $message = "$otp is your OTP for U app login.";
            //$this->send_otp_sms_post($mobile,$otp);
       //  echo  $this->send_otp_sms_post($mobile,$otp);exit;
            // SendSMS($mobile, $message);
            //$message = "Dear user, OTP for Yummazing App is " . $otp . ", please don't share. Valid for 10 mins. Regards, Yummazing Team ";
            //SendSMSSarvi($mobile, $message);
            //$subject = "Sami Grocery-OTP";
            //SendMAIL($email_id, $message, $subject);
            
           
           $response = array('status' => true, 'message' => 'Otp sent successfully!', 'response' => array('otp' => "$otp") );
            $this->response($response);
          
            
               }else if($otp_confirmed == 'yes'){
                   
                   if(empty($languages)){
            $response = array('status' => false, 'message' => 'Languages Is Empty', 'response' => array());
            $this->response($response);
        }else{
               $data = array(
    			            'mobile' => $mobile,
    			            'email' => $email,
    			            'name' => $name,
    			            'dob' => $dob,
    			            'gender' => $gender,
    			            'from_city' => $from_city,
    			            'stay_city' => $stay_city,
    			           // 'latitude' => $latitude,
    			            //'longitude' => $longitude,
    			            'height_in_feet' => $height_in_feet,
    			            'height_in_inches' => $height_in_inches,
    			            'height_in_centimeters' => $height_in_centimeters,
    			            'height_unit' => $height_unit,
    			            'religion' => $religion,
    			            'zodiac' => $zodiac,
    			            'status' => 1,
    			            'created_on' =>date('Y-m-d H:i:s')
    			            );
    			            $insert = $this->user_model->common_insert('users',$data);
    			            if($insert){
    			                
    			                 /*languages */
    			                if(!empty($languages)){
    			                    $lan = explode(',',$languages);
    			                    foreach($lan as $l){
    			                        $datal = array(
    			                            
    			                            'user_id' => $insert,
    			                            'language_id' => $l,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_languages',$datal);
    			                        
    			                    }
    			                }
    			            }
    			            $this->token_get_registration($insert,$token,$player_id);
    			            
    				$response = array('status' => true, 'message' => 'Registration Completed Successfully', 'response' => array());
    				$this->response($response);
        }
             
    			
    			    
    			     
    			
            

        }
        
            }
           			
	//	}
	}
	/*user registartion update*/
	
	/*user location update */
	public function update_location_post()
    {
        $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($latitude)){
            $response = array('status' => false, 'message' => 'Latitude Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($longitude)){
            $response = array('status' => false, 'message' => 'Longitude Is Empty', 'response' => (object)array());
            $this->response($response);
        }
        // else if(empty($address)){
        //     $response = array('status' => false, 'message' => 'Address Is Empty', 'response' => (object)array());
        //     $this->response($response);
        // }
        else{
    			$data = array(
    			    'latitude' => $latitude,
    			    'longitude' => $longitude,
    			    'address' => $address,
    			    'updated_on' => date('Y-m-d H:i:s')
    			    );
    			    $this->user_model->common_update('users',$data,array('id' => $user_id));
    			//echo $this->db->last_query();exit;
    			
    			   	$response = array('status' => true, 'message' => 'Location Details  Updated Successfully', 'response' => (object)array());
    				$this->response($response);
    			
            
			
		}
    }
	/*user location update */
	
	/*locations details*/
	public function all_locations_get()
	{
	    //$user_input = $this->client_request;
	    //extract($user_input);
	    
	    $cities = $this->user_model->common_fetch('cities',array('delete_status' => '1'));
	    if(empty($cities)){
	        $response = array('status' => false, 'message' => 'Empty Cities Details', 'response' => array());
				$this->response($response);
	    }else{
	            $response = array('status' => true, 'message' => 'All Cities Details Fetched', 'response' => $cities);
				$this->response($response);
	    }
	}
	/*loactions get*/
	
	/*locations details*/
	public function all_religions_get()
	{
	    //$user_input = $this->client_request;
	    //extract($user_input);
	    
	    $cities = $this->user_model->common_fetch('religions',array('delete_status' => '1'));
	    if(empty($cities)){
	        $response = array('status' => false, 'message' => 'Empty Religions Details', 'response' => (object)array());
				$this->response($response);
	    }else{
	            $response = array('status' => true, 'message' => 'All Religions Details Fetched', 'response' => $cities);
				$this->response($response);
	    }
	}
	/*loactions get*/
	/*achievements details*/
	public function all_achievements_get()
	{
	    //$user_input = $this->client_request;
	    //extract($user_input);
	    
	    $cities = $this->user_model->common_fetch('achievements',array('delete_status' => '1'));
	    if(empty($cities)){
	        $response = array('status' => false, 'message' => 'Empty Achievements Details', 'response' => (object)array());
				$this->response($response);
	    }else{
	            $response = array('status' => true, 'message' => 'All Achievements Details Fetched', 'response' => $cities);
				$this->response($response);
	    }
	}
	/*achievements get*/
	/*professional connections details*/
	public function all_professional_connections_get()
	{
	    //$user_input = $this->client_request;
	    //extract($user_input);
	    
	    $cities = $this->user_model->common_fetch('professional_connections',array('delete_status' => '1'));
	    if(empty($cities)){
	        $response = array('status' => false, 'message' => 'Empty Professional Connections Details', 'response' => (object)array());
				$this->response($response);
	    }else{
	            $response = array('status' => true, 'message' => 'All Professional Connections Details Fetched', 'response' => $cities);
				$this->response($response);
	    }
	}
	/*professional connections get*/
	
	/*activities view*/

	public function all_activities_post()
	{
		$user_input = $this->client_request;
        extract($user_input);
        if(empty($type)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
    			$get = $this->user_model->get_all_activities($type);
    			//echo $this->db->last_query();exit;
    			if(empty($get)){
    				$response = array('status' => false, 'message' => 'Empty Activities Details', 'response' => array());
    				$this->response($response);
    			}else{
    			   	$response = array('status' => true, 'message' => 'Activities Details  Fetched Successfully', 'response' => $get);
    				$this->response($response);
    			}
            
			
		}
	}
	/*activities view*/
	
	/*activities view*/
	public function all_foods_get()
	{
		
    			$get = $this->user_model->get_all_foods();
    			//echo $this->db->last_query();exit;
    			if(empty($get)){
    				$response = array('status' => false, 'message' => 'Empty Food Details', 'response' => array());
    				$this->response($response);
    			}else{
    			   	$response = array('status' => true, 'message' => 'Food Details  Fetched Successfully', 'response' => $get);
    				$this->response($response);
    			}
            
			
		
	}
	/*activities view*/
	
	/*interests view*/
	public function all_interests_post()
	{
		$user_input = $this->client_request;
        extract($user_input);
        if(empty($type)){
            $response = array('status' => false, 'message' => 'Type Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
    			$get = $this->user_model->get_all_interests($type);
    			//echo $this->db->last_query();exit;
    			if(empty($get)){
    				$response = array('status' => false, 'message' => 'Empty Interest Details', 'response' => array());
    				$this->response($response);
    			}else{
    			   	$response = array('status' => true, 'message' => 'Interests Details  Fetched Successfully', 'response' => $get);
    				$this->response($response);
    			}
            
			
		}
	}
	/*interests view*/
	
	/*interests view*/
	public function all_looking_for_post()
	{
		$user_input = $this->client_request;
        extract($user_input);
        if(empty($type)){
            $response = array('status' => false, 'message' => 'Type Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
    			$get = $this->user_model->get_all_looking_for($type);
    			//echo $this->db->last_query();exit;
    			if(empty($get)){
    				$response = array('status' => false, 'message' => 'Empty Looking For Details', 'response' => array());
    				$this->response($response);
    			}else{
    			   	$response = array('status' => true, 'message' => 'Looking For Details  Fetched Successfully', 'response' => $get);
    				$this->response($response);
    			}
            
			
		}
	}
	/*interests view*/
	
	/*interests view*/
	public function all_personality_traits_post()
	{
		$user_input = $this->client_request;
        extract($user_input);
        if(empty($type)){
            $response = array('status' => false, 'message' => 'Type Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
    			$get = $this->user_model->get_all_personality_traits($type);
    			//echo $this->db->last_query();exit;
    			if(empty($get)){
    				$response = array('status' => false, 'message' => 'Empty Personality Traits Details', 'response' => array());
    				$this->response($response);
    			}else{
    			   	$response = array('status' => true, 'message' => 'Personality Traits Details  Fetched Successfully', 'response' => $get);
    				$this->response($response);
    			}
            
			
		}
	}
	/*interests view*/
	
	/*preferences view*/
	public function all_preferences_post()
	{
		$user_input = $this->client_request;
        extract($user_input);
        if(empty($type)){
            $response = array('status' => false, 'message' => 'Type Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
    			$get = $this->user_model->get_all_preferences($type);
    			//echo $this->db->last_query();exit;
    			if(empty($get)){
    				$response = array('status' => false, 'message' => 'Empty preferences Details', 'response' => array());
    				$this->response($response);
    			}else{
    			   	$response = array('status' => true, 'message' => 'preferences Details  Fetched Successfully', 'response' => $get);
    				$this->response($response);
    			}
            
			
		}
	}
	/*interests view*/
	
		/*preferences view*/
	public function all_languages_get()
	{
    			$get = $this->user_model->common_fetch('languages', array('delete_status' => 1));
    			//echo $this->db->last_query();exit;
    			if(empty($get)){
    				$response = array('status' => false, 'message' => 'Empty Languages Details', 'response' => array());
    				$this->response($response);
    			}else{
    			   	$response = array('status' => true, 'message' => 'Languages Details  Fetched Successfully', 'response' => $get);
    				$this->response($response);
    			}
            
			
		
	}
	/*interests view*/
	
		/*user pal registartion */
	public function user_pal_registration_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($pics)){
            $response = array('status' => false, 'message' => 'Pics are Empty', 'response' => (object)array());
            $this->response($response);
        }else{
            $check = $this->user_model->common_fetch('pal_registrations',array('user_id' => $user_id));
        
    			        $data = array(
    			            'user_id' => $user_id,
    			            'about' => $about,
    			           // 'height_in_feet' => $height_in_feet,
    			         //   'height_in_inches' => $height_in_inches,
    			         //   'height_in_centimeters' => $height_in_centimeters,
    			        //    'height_unit' => $height_unit,
    			            'designation' => $designation,
    			            'workplace_institution' => $workplace_institution,
    			          //  'religion' => $religion,
    			          //  'zodiac' => $zodiac,
    			            'introvert_extravert_ambivort' => $introvert_extravert_ambivort,
    			            'created_on' =>date('Y-m-d H:i:s')
    			            );
    			            $insert = $this->user_model->common_insert('pal_registrations',$data);
    			            if($insert){
    			                /*looking for*/
    			                if(!empty($looking_for)){
    			                    $look = explode(',',$looking_for);
    			                    foreach($look as $l){
    			                        $datal = array(
    			                            'user_type' => 'pal',
    			                            'user_type_id' => $insert,
    			                            'looking_for_id' => $l,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_looking_for',$datal);
    			                        
    			                    }
    			                }
    			                /*intrestes*/
    			                if(!empty($interests)){
    			                    $int = explode(',',$interests);
    			                    foreach($int as $i){
    			                        $datai = array(
    			                            'user_type' => 'pal',
    			                            'user_type_id' => $insert,
    			                            'interest_id' => $i,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_interests',$datai);
    			                        
    			                    }
    			                }
    			                 /*personality_traits*/
    			                if(!empty($personality_traits)){
    			                    $per = explode(',',$personality_traits);
    			                    foreach($per as $p){
    			                        $datap = array(
    			                            'user_type' => 'pal',
    			                            'user_type_id' => $insert,
    			                            'personality_traits_id' => $p,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_personality_traits',$datap);
    			                        
    			                    }
    			                }
    			                /*user_preferences*/
    			                if(!empty($preferences)){
    			                    $pref = explode(',',$preferences);
    			                    foreach($pref as $f){
    			                        $dataf = array(
    			                            'user_type' => 'pal',
    			                            'user_type_id' => $insert,
    			                            'preference_id' => $f,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_preferences',$dataf);
    			                        
    			                    }
    			                }
    			                /*food*/
    			                if(!empty($foods)){
    			                    $foo = explode(',',$foods);
    			                    foreach($foo as $o){
    			                        $datao = array(
    			                            'user_type' => 'pal',
    			                            'user_type_id' => $insert,
    			                            'food_id' => $o,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_food',$datao);
    			                        
    			                    }
    			                }
    			                /*activities*/
    			                if(!empty($activities)){
    			                    $act = explode(',',$activities);
    			                    foreach($act as $a){
    			                        $dataa = array(
    			                            'user_type' => 'pal',
    			                            'user_type_id' => $insert,
    			                            'activity_id' => $a,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_activities',$dataa);
    			                        
    			                    }
    			                }
    			                /*user images*/
    			                if(!empty($pics)){
    			                    
    			                    $pics_array = explode(",",$pics);
                            foreach($pics_array as $pic){ 
                               if(!empty($pic)){
                                   define('IMAGE_UPLOAD_DIR','assets/images/users_pics/');
                    				$img = str_replace('data:image/jpeg;base64','',$pic);
                    				$img = str_replace(' ','+',$img);
                    				$user_data = base64_decode($img);
                    				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
                    				$success = file_put_contents($user_file,$user_data); 
				
                    				if($success){
                    				   // $image_link = $user_file;
                    				//     unlink($get_child_detaiils[0]['father_image']);
                        				
                        				    $data1 = array(
                        						'user_type' => 'pal',
                        						'user_type_id' =>$insert,
                        						'image_link' => $user_file,
                        						'created_on' => date('Y-m-d H:i:s')
                        						);
                        					 $this->user_model->common_insert('user_images',$data1);
                    				}
                               } 
                                
    			            
                            }//foreach
                            
                            
                            
    			                    
    			                }
    			                
    			            }
    				$response = array('status' => true, 'message' => 'Registration Details Updated Successfully', 'response' => array());
    				$this->response($response);
    			
            
			
		}
	}
	/*user pal registration */
	
	/*user par registartion */
	public function user_par_registration_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($pics)){
            $response = array('status' => false, 'message' => 'Pics are Empty', 'response' => (object)array());
            $this->response($response);
        }else{
            $check = $this->user_model->common_fetch('par_registrations',array('user_id' => $user_id));
        
    			        $data = array(
    			            'user_id' => $user_id,
    			            'about' => $about,
    			            'height_in_feet' => $height_in_feet,
    			            'height_in_inches' => $height_in_inches,
    			            'height_in_centimeters' => $height_in_centimeters,
    			            'height_unit' => $height_unit,
    			            'designation' => $designation,
    			            'workplace_institution' => $workplace_institution,
    			            'religion' => $religion,
    			            'zodiac' => $zodiac,
    			            'introvert_extravert_ambivort' => $introvert_extravert_ambivort,
    			            'created_on' =>date('Y-m-d H:i:s')
    			            );
    			            $insert = $this->user_model->common_insert('par_registrations',$data);
    			            if($insert){
    			                /*looking for*/
    			                if(!empty($looking_for)){
    			                    $look = explode(',',$looking_for);
    			                    foreach($look as $l){
    			                        $datal = array(
    			                            'user_type' => 'par',
    			                            'user_type_id' => $insert,
    			                            'looking_for_id' => $l,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_looking_for',$datal);
    			                        
    			                    }
    			                }
    			                /*intrestes*/
    			                if(!empty($interests)){
    			                    $int = explode(',',$interests);
    			                    foreach($int as $i){
    			                        $datai = array(
    			                            'user_type' => 'par',
    			                            'user_type_id' => $insert,
    			                            'interest_id' => $i,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_interests',$datai);
    			                        
    			                    }
    			                }
    			                 /*personality_traits*/
    			                if(!empty($personality_traits)){
    			                    $per = explode(',',$personality_traits);
    			                    foreach($per as $p){
    			                        $datap = array(
    			                            'user_type' => 'par',
    			                            'user_type_id' => $insert,
    			                            'personality_traits_id' => $p,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_personality_traits',$datap);
    			                        
    			                    }
    			                }
    			                /*user_preferences*/
    			                if(!empty($preferences)){
    			                    $pref = explode(',',$preferences);
    			                    foreach($pref as $f){
    			                        $dataf = array(
    			                            'user_type' => 'par',
    			                            'user_type_id' => $insert,
    			                            'preference_id' => $f,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_preferences',$dataf);
    			                        
    			                    }
    			                }
    			                /*food*/
    			                if(!empty($foods)){
    			                    $foo = explode(',',$foods);
    			                    foreach($foo as $o){
    			                        $datao = array(
    			                            'user_type' => 'par',
    			                            'user_type_id' => $insert,
    			                            'food_id' => $o,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_food',$datao);
    			                        
    			                    }
    			                }
    			                /*activities*/
    			                if(!empty($activities)){
    			                    $act = explode(',',$activities);
    			                    foreach($act as $a){
    			                        $dataa = array(
    			                            'user_type' => 'par',
    			                            'user_type_id' => $insert,
    			                            'activity_id' => $a,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_activities',$dataa);
    			                        
    			                    }
    			                }
    			                /*user images*/
    			                if(!empty($pics)){
    			                    
    			                    $pics_array = explode(",",$pics);
                            foreach($pics_array as $pic){ 
                               if(!empty($pic)){
                                   define('IMAGE_UPLOAD_DIR','assets/images/users_pics/');
                    				$img = str_replace('data:image/jpeg;base64','',$pic);
                    				$img = str_replace(' ','+',$img);
                    				$user_data = base64_decode($img);
                    				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
                    				$success = file_put_contents($user_file,$user_data); 
				
                    				if($success){
                    				   // $image_link = $user_file;
                    				//     unlink($get_child_detaiils[0]['father_image']);
                        				
                        				    $data1 = array(
                        						'user_type' => 'par',
                        						'user_type_id' =>$insert,
                        						'image_link' => $user_file,
                        						'created_on' => date('Y-m-d H:i:s')
                        						);
                        					 $this->user_model->common_insert('user_images',$data1);
                    				}
                               } 
                                
    			            
                            }//foreach
                            
                            
                            
    			                    
    			                }
    			                
    			            }
    				$response = array('status' => true, 'message' => 'Registration Details Updated Successfully', 'response' => array());
    				$this->response($response);
    			
            
			
		}
	}
	/*user pal registration */
	
		/*user par registartion */
	public function user_pro_registration_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($pics)){
            $response = array('status' => false, 'message' => 'Pics are Empty', 'response' => (object)array());
            $this->response($response);
        }else{
            $check = $this->user_model->common_fetch('pro_registrations',array('user_id' => $user_id));
        
    			        $data = array(
    			            'user_id' => $user_id,
    			            'about' => $about,
    			           // 'height_in_feet' => $height_in_feet,
    			          //  'height_in_inches' => $height_in_inches,
    			           // 'height_in_centimeters' => $height_in_centimeters,
    			          //  'height_unit' => $height_unit,
    			            'title' => $title,
    			            'industry' => $industry,
    			            'experience' => $experience,
    			            'education' => $education,
    			            'location' => $location,
    			            'website' => $website,
    			            'created_on' =>date('Y-m-d H:i:s')
    			            );
    			            $insert = $this->user_model->common_insert('pro_registrations',$data);
    			            if($insert){
    			                /*looking for*/
    			                if(!empty($looking_for)){
    			                    $look = explode(',',$looking_for);
    			                    foreach($look as $l){
    			                        $datal = array(
    			                            'user_type' => 'pro',
    			                            'user_type_id' => $insert,
    			                            'looking_for_id' => $l,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_looking_for',$datal);
    			                        
    			                    }
    			                }
    			                /*intrestes*/
    			                if(!empty($interests)){
    			                    $int = explode(',',$interests);
    			                    foreach($int as $i){
    			                        $datai = array(
    			                            'user_type' => 'pro',
    			                            'user_type_id' => $insert,
    			                            'interest_id' => $i,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_interests',$datai);
    			                        
    			                    }
    			                }
    			                 /*personality_traits*/
    			                if(!empty($achievements)){
    			                    $per = explode(',',$achievements);
    			                    foreach($per as $p){
    			                        $datap = array(
    			                            'user_type' => 'pro',
    			                            'user_type_id' => $insert,
    			                            'achievement_id' => $p,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_achievements',$datap);
    			                        
    			                    }
    			                }
    			                /*user_preferences*/
    			                if(!empty($professional_connections)){
    			                    $pref = explode(',',$professional_connections);
    			                    foreach($pref as $f){
    			                        $dataf = array(
    			                            'user_type' => 'pro',
    			                            'user_type_id' => $insert,
    			                            'professional_connection_id' => $f,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_professional_connections',$dataf);
    			                        
    			                    }
    			                }
    			                /*user images*/
    			                if(!empty($pics)){
    			                    
    			                    
                               if(!empty($pics)){
                                   define('IMAGE_UPLOAD_DIR','assets/images/users_pics/');
                    				$img = str_replace('data:image/jpeg;base64','',$pics);
                    				$img = str_replace(' ','+',$img);
                    				$user_data = base64_decode($img);
                    				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
                    				$success = file_put_contents($user_file,$user_data); 
				
                    				if($success){
                    				   // $image_link = $user_file;
                    				//     unlink($get_child_detaiils[0]['father_image']);
                        				
                        				    $data1 = array(
                        						'user_type' => 'pro',
                        						'user_type_id' =>$insert,
                        						'image_link' => $user_file,
                        						'created_on' => date('Y-m-d H:i:s')
                        						);
                        					 $this->user_model->common_insert('user_images',$data1);
                    				}
                               } 
                                
    			            
                            
                            
                            
                            
    			                    
    			                }
    			                
    			            }
    				$response = array('status' => true, 'message' => 'Registration Details Updated Successfully', 'response' => array());
    				$this->response($response);
    			
            
			
		}
	}
	/*user pro registration */
	
	/* user profile */
	/*preferences view*/
	public function user_profile_post()
	{
		$user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }
        // else if(empty($user_type)){
        //     $response = array('status' => false, 'message' => 'User Type Is Empty', 'response' => (object)array());
        //     $this->response($response);
        // }
        else{
            $user = $this->user_model->common_fetch('users',array('id' => $user_id));
            $all = array();
            $details = array();
            $pal['name'] = $user[0]['name'];
            $pal['age'] = $this->calculateAge($user[0]['dob']);
           // echo $user[0]['dob'];
          //  echo $this->calculateAge($user[0]['dob']);exit;
            $pal['subscription'] = 'no';
            $pal['profile_type'] = "pal";
            $pal['profile_verified'] = "yes";
            $get = $this->user_model->get_pal_pics($user_id);
                 if(!empty($get[0]) && !empty($get[0]['image_link'])){
                     $pal['profile_pic'] = $get[0]['image_link'];
                     $pal['created_on'] = $get[0]['date'];
                 }else{
                     $pal['profile_pic'] = '';
                     $pal['created_on'] = '';
                 }
                 
            $details[0] = $pal;
            
            
            $par['name'] = $user[0]['name'];
            $par['age'] = $this->calculateAge($user[0]['dob']);
            $par['subscription'] = 'no';
            $par['profile_type'] = "par";
            $par['profile_verified'] = "yes";
             
            $get = $this->user_model->get_par_pics($user_id);
                 if(!empty($get) && !empty($get[0]['image_link'])){
                     $par['profile_pic'] = $get[0]['image_link'];
                     $par['created_on'] = $get[0]['date'];
                 }else{
                     $par['profile_pic'] = '';
                     $par['created_on'] = '';
                 }
               $details[1] = $par;  
               
               $pro['name'] = $user[0]['name'];
            $pro['age'] = $this->calculateAge($user[0]['dob']);
            $pro['subscription'] = 'no';
            $pro['profile_type'] = "pro";
            $pro['profile_verified'] = "yes";
            $get = $this->user_model->get_pro_pics($user_id);
                 if(!empty($get) && !empty($get[0]['image_link'])){
                     $pro['profile_pic'] = $get[0]['image_link'];
                     $pro['created_on'] = $get[0]['date'];
                 }else{
                     $pro['profile_pic'] = '';
                     $pro['created_on'] = '';
                 }
            
            $details[2] = $pro; 
            
            //  if($user_type == "pal")
            //  {
            //      $get = $this->user_model->get_pal_pics($user_id);
            //      if(!empty($get[0]) && !empty($get[0]['image_link'])){
            //          $details['pic'] = $get[0]['image_link'];
            //      }else{
            //          $details['pic'] = '';
            //      }
            //  }else if($user_type == "par"){
            //      $get = $this->user_model->get_par_pics($user_id);
            //      if(!empty($get) && !empty($get[0]['image_link'])){
            //          $details['pic'] = $get[0]['image_link'];
            //      }else{
            //          $details['pic'] = '';
            //      }
            //  }else if($user_type == "pro"){
            //      $get = $this->user_model->get_pro_pics($user_id);
            //      if(!empty($get) && !empty($get[0]['image_link'])){
            //          $details['pic'] = $get[0]['image_link'];
            //      }else{
            //          $details['pic'] = '';
            //      }
            //  }else{
            //      $response = array('status' => false, 'message' => 'User Type Is Invalid', 'response' => (object)array());
            // $this->response($response);
            //  }
            
            // Sort array based on 'created_on' (latest first)
//   usort($details, function ($a, $b) {
//     $detailsA = strtotime($a['created_on'] ?? '0000-00-00 00:00:00');
//     $detailsB = strtotime($b['created_on'] ?? '0000-00-00 00:00:00');
//     return    $detailsA - $detailsB;
// });

usort($details, function ($a, $b) {
    // If created_on is empty, treat it as a future date so it comes last
    $dateA = strtotime(!empty($a['created_on']) ? $a['created_on'] : '9999-12-31 23:59:59');
    $dateB = strtotime(!empty($b['created_on']) ? $b['created_on'] : '9999-12-31 23:59:59');
    return $dateA - $dateB; // Ascending: oldest first
});


    		
    				$response = array('status' => true, 'message' => 'Fetched User profile Details', 'response' => $details);
    				$this->response($response);
    			
            
			
		}
	}
	
	function calculateAge($dob) {
    $dob = new DateTime($dob); // Convert DOB to DateTime object
    $today = new DateTime();   // Current date
    $age = $today->diff($dob); // Difference between today and DOB
    return $age->y;            // Return age in years
}
	/*interests view*/
	
	/* usetr profile*/
	
	/* user view profile */
	public function view_profile_post()
	{
	    	$user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($user_type)){
            $response = array('status' => false, 'message' => 'User Type Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
            $user = $this->user_model->get_user_details_all($user_id);
            $pal_details = $this->user_model->common_fetch('pal_registrations',array('user_id' => $user_id));
            $par_details = $this->user_model->common_fetch('par_registrations',array('user_id' => $user_id));
            $pro_details = $this->user_model->common_fetch('pro_registrations',array('user_id' => $user_id));
            
             if($user_type == "pal"){
                 $get = $this->user_model->get_pal_details_all($user_id);
                // echo $this->db->last_query();
             //   print_r($get);exit;
                 if(empty($get)){
                     if(!empty($par_details) || !empty($pro_details)){
                         if(!empty($par_details)){
                             $about = $par_details[0]['about'];
                            //  $height_in_feet = $par_details[0]['height_in_feet'];
                            //  $height_in_inches = $par_details[0]['height_in_inches'];
                            //  $height_in_centimeters = $par_details[0]['height_in_centimeters'];
                            //  $height_unit = $par_details[0]['height_unit'];
                         }
                         if(!empty($pro_details)){
                             $about = $pro_details[0]['about'];
                            //  $height_in_feet = $pro_details[0]['height_in_feet'];
                            //  $height_in_inches = $pro_details[0]['height_in_inches'];
                            //  $height_in_centimeters = $pro_details[0]['height_in_centimeters'];
                            //  $height_unit = $pro_details[0]['height_unit'];
                         }
                         $insert = $this->user_model->common_insert('pal_registrations',array('user_id' => $user_id
                //          'height_in_feet' => $height_in_feet,
    			         //   'height_in_inches' => $height_in_inches,
    			         //   'height_in_centimeters' => $height_in_centimeters,
    			         //   'height_unit' => $height_unit
    			            ));
                     }
                     $get = $this->user_model->get_pal_details_all($user_id);
                     
                 }
                 
              //  echo "<pre>";
             //   print_r($get);exit;
                 
                 $pics = $this->user_model->common_fetch('user_images',array('user_type' => 'pal', 'user_type_id' => $get[0]['user_type_id']));
                 
             }else if($user_type == "par"){
                 $get = $this->user_model->get_par_details_all($user_id);
                 
                  if(empty($get)){
                     if(!empty($pal_details) || !empty($pro_details)){
                         if(!empty($pal_details)){
                             $about = $pal_details[0]['about'];
                            //   $height_in_feet = $pal_details[0]['height_in_feet'];
                            //  $height_in_inches = $pal_details[0]['height_in_inches'];
                            //  $height_in_centimeters = $pal_details[0]['height_in_centimeters'];
                            //  $height_unit = $pal_details[0]['height_unit'];
                         }
                         if(!empty($pro_details)){
                             $about = $pro_details[0]['about'];
                            //   $height_in_feet = $pro_details[0]['height_in_feet'];
                            //  $height_in_inches = $pro_details[0]['height_in_inches'];
                            //  $height_in_centimeters = $pro_details[0]['height_in_centimeters'];
                            //  $height_unit = $pro_details[0]['height_unit'];
                         }
                         $insert = $this->user_model->common_insert('par_registrations',array('user_id' => $user_id
                //          'height_in_feet' => $height_in_feet,
    			         //   'height_in_inches' => $height_in_inches,
    			         //   'height_in_centimeters' => $height_in_centimeters,
    			         //   'height_unit' => $height_unit
    			            ));
                     }
                     $get = $this->user_model->get_par_details_all($user_id);
                     
                 }
                 
                 
              
                 
                 $pics = $this->user_model->common_fetch('user_images',array('user_type' => 'par', 'user_type_id' => $get[0]['user_type_id']));
                 
             }else if($user_type == "pro"){
                 $get = $this->user_model->get_pro_details_all($user_id);
                 
                  if(empty($get)){
                     if(!empty($pal_details) || !empty($par_details)){
                         if(!empty($pal_details)){
                             $about = $pal_details[0]['about'];
                            //  $height_in_feet = $pal_details[0]['height_in_feet'];
                            //  $height_in_inches = $pal_details[0]['height_in_inches'];
                            //  $height_in_centimeters = $pal_details[0]['height_in_centimeters'];
                            //  $height_unit = $pal_details[0]['height_unit'];
                         }
                         if(!empty($par_details)){
                             $about = $par_details[0]['about'];
                            //  $height_in_feet = $par_details[0]['height_in_feet'];
                            //  $height_in_inches = $par_details[0]['height_in_inches'];
                            //  $height_in_centimeters = $par_details[0]['height_in_centimeters'];
                            //  $height_unit = $par_details[0]['height_unit'];
                         }
                         $insert = $this->user_model->common_insert('pro_registrations',array('user_id' => $user_id
                //          'height_in_feet' => $height_in_feet,
    			         //   'height_in_inches' => $height_in_inches,
    			         //   'height_in_centimeters' => $height_in_centimeters,
    			         //   'height_unit' => $height_unit
    			            ));
                     }
                     $get = $this->user_model->get_pro_details_all($user_id);
                     
                 }
                //  else if($get[0]['height_in_feet'] == 0 && $get[0]['height_in_inches'] == 0 &&
                //  $get[0]['height_in_centimeters'] == 0 && $get[0]['height_unit'] == ""){
                     
                //      if(!empty($pal_details) || !empty($par_details)){
                //          if(!empty($pal_details)){
                //              $about = $pal_details[0]['about'];
                //             //  $height_in_feet = $pal_details[0]['height_in_feet'];
                //             //  $height_in_inches = $pal_details[0]['height_in_inches'];
                //             //  $height_in_centimeters = $pal_details[0]['height_in_centimeters'];
                //             //  $height_unit = $pal_details[0]['height_unit'];
                //          }
                //          if(!empty($par_details)){
                //              $about = $par_details[0]['about'];
                //             //  $height_in_feet = $par_details[0]['height_in_feet'];
                //             //  $height_in_inches = $par_details[0]['height_in_inches'];
                //             //  $height_in_centimeters = $par_details[0]['height_in_centimeters'];
                //             //  $height_unit = $par_details[0]['height_unit'];
                //          }
                //          $insert = $this->user_model->common_update('pro_registrations',array('user_id' => $user_id
                // //          'height_in_feet' => $height_in_feet,
    			         ////   'height_in_inches' => $height_in_inches,
    			         ////   'height_in_centimeters' => $height_in_centimeters,
    			         ////   'height_unit' => $height_unit
    			         //   ),array('user_id' => $user_id));
                //      }
                //      $get = $this->user_model->get_pro_details_all($user_id);
                     
                //  }
                 
                 $pics = $this->user_model->common_fetch('user_images',array('user_type' => 'pro', 'user_type_id' => $get[0]['user_type_id']));
                
                 
             }else{
                 $response = array('status' => false, 'message' => 'User Type Is Invalid', 'response' => (object)array());
            $this->response($response);
             }
             if(empty($get)){
                 $get[0] = [];
             }
             
            $all =  array_merge($user[0],$get[0]);
            $all['pics'] = $pics;
    		
    				$response = array('status' => true, 'message' => 'User Profile Details', 'response' => $all);
    				$this->response($response);
    			
            
			
		}

	}
	/* user view profile */
	
	/* update pal details */
    public function update_pal_deatils_post()
     {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($pal_id)){
            $response = array('status' => false, 'message' => 'Pal ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else if($check_user[0]['status'] == 0 || $check_user[0]['delete_status'] == 0){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                
                if(!empty($email)){
                     $data = array(
    			       'email' => $email,
    			     //  'created_on' => date('Y-m-d H:i:s'),
    			       'updated_on' => date('Y-m-d H:i:s')
    			       );
                }else if(!empty($name) && !empty($dob)){
                     $data = array(
    			       'name' => $name,
    			       'dob'  => $dob,
    			      // 'created_on' => date('Y-m-d H:i:s'),
    			       'updated_on' => date('Y-m-d H:i:s')
    			       );
                }else if(!empty($gender)){
                     $data = array(
    			       'gender' => $gender,
    			     //  'created_on' => date('Y-m-d H:i:s'),
    			       'updated_on' => date('Y-m-d H:i:s')
    			       );
                }else if(!empty($from_city)){
                     $data = array(
    			       'from_city' => $from_city,
    			       'created_on' => date('Y-m-d H:i:s'),
    			       'updated_on' => date('Y-m-d H:i:s')
    			       );
                }else if(!empty($stay_city)){
                     $data = array(
    			       'stay_city' => $stay_city,
    			     //  'created_on' => date('Y-m-d H:i:s'),
    			       'updated_on' => date('Y-m-d H:i:s')
    			       );
                } else if(!empty($height_in_feet) || !empty($height_in_inches) || !empty($height_in_centimeters)){
                        $data = array(
                            'height_in_feet' => $height_in_feet,
                            'height_in_inches' => $height_in_inches,
                            'height_in_centimeters' => $height_in_centimeters,
                            'height_unit' => $height_unit,
                            'updated_on' => date('Y-m-d H:i:s')
                            );
                    }else if(!empty($religion)){
                        $data = array(
                            'religion' => $religion,
                            'updated_on' => date('Y-m-d H:i:s')
                            );
                    }else if(!empty($zodiac)){
                        $data = array(
                            'zodiac' => $zodiac,
                            'updated_on' => date('Y-m-d H:i:s')
                            );
                    }else{
                    $data = '';
                }
                if(!empty($data)){
                     $user_update = $this->user_model->common_update('users',$data,array('id' => $user_id));
    		
                }
                
                 /*languages */
    			                if(!empty($languages)){
                    $delete = $this->user_model->common_p_delete('user_languages',array('user_id' => $user_id));
    			                    $lan = explode(',',$languages);
    			                    foreach($lan as $l){
    			                        $datal = array(
    			                            'user_id' => $user_id,
    			                            'language_id' => $l,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_languages',$datal);
    			                        
    			                    }
    			                }
                
                
                
                if(!empty($pal_id)){
                    
                  $fetchpal =   $this->user_model->common_fetch('pal_registrations',array('id' => $pal_id));
                  if(!empty($fetchpal) && empty($fetchpal[0]['created_on'])){
                      $this->user_model->common_update('pal_registrations',array('created_on' => date('Y-m-d H:i:s')),array('id' => $pal_id));
                  }
                    
                    if(!empty($about)){
                        $data_pal = array(
                            'about' => $about,
                            'updated_on' => date('Y-m-d H:i:s')
                            );
                    }
                    // else if(!empty($height_in_feet) || !empty($height_in_inches) || !empty($height_in_centimeters)){
                    //     $data_pal = array(
                    //         'height_in_feet' => $height_in_feet,
                    //         'height_in_inches' => $height_in_inches,
                    //         'height_in_centimeters' => $height_in_centimeters,
                    //         'height_unit' => $height_unit,
                    //         'updated_on' => date('Y-m-d H:i:s')
                    //         );
                    // }
                    
                    else if(!empty($designation)){
                        $data_pal = array(
                            'designation' => $designation,
                            'updated_on' => date('Y-m-d H:i:s')
                            );
                    }else if(!empty($workplace_institution)){
                        $data_pal = array(
                            'workplace_institution' => $workplace_institution,
                            'updated_on' => date('Y-m-d H:i:s')
                            );
                    }
                    // else if(!empty($religion)){
                    //     $data_pal = array(
                    //         'religion' => $religion,
                    //         'updated_on' => date('Y-m-d H:i:s')
                    //         );
                    // }else if(!empty($zodiac)){
                    //     $data_pal = array(
                    //         'zodiac' => $zodiac,
                    //         'updated_on' => date('Y-m-d H:i:s')
                    //         );
                    // }
                    else if(!empty($introvert_extravert_ambivort)){
                        $data_pal = array(
                            'introvert_extravert_ambivort' => $introvert_extravert_ambivort,
                            'updated_on' => date('Y-m-d H:i:s')
                            );
                    }else{
                        $data_pal = '';
                    }
                    if(!empty($data_pal)){
                        $user_update = $this->user_model->common_update('pal_registrations',$data_pal,array('id' => $pal_id));
                    }
                    
                    /*looking for*/
    			                if(!empty($looking_for)){
    			                    $delete = $this->user_model->common_p_delete('user_looking_for',array('user_type' => 'pal','user_type_id' => $pal_id));
    			                    $look = explode(',',$looking_for);
    			                    foreach($look as $l){
    			                        $datal = array(
    			                            'user_type' => 'pal',
    			                            'user_type_id' => $pal_id,
    			                            'looking_for_id' => $l,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_looking_for',$datal);
    			                        
    			                    }
    			                }
    			                /*intrestes*/
    			                if(!empty($interests)){
    			                    $delete = $this->user_model->common_p_delete('user_interests',array('user_type' => 'pal','user_type_id' => $pal_id));
    			                    $int = explode(',',$interests);
    			                    foreach($int as $i){
    			                        $datai = array(
    			                            'user_type' => 'pal',
    			                            'user_type_id' => $pal_id,
    			                            'interest_id' => $i,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_interests',$datai);
    			                        
    			                    }
    			                }
    			                 /*personality_traits*/
    			                if(!empty($personality_traits)){
    			                    $delete = $this->user_model->common_p_delete('user_personality_traits',array('user_type' => 'pal','user_type_id' => $pal_id));
    			                    $per = explode(',',$personality_traits);
    			                    foreach($per as $p){
    			                        $datap = array(
    			                            'user_type' => 'pal',
    			                            'user_type_id' => $pal_id,
    			                            'personality_traits_id' => $p,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_personality_traits',$datap);
    			                        
    			                    }
    			                }
    			                /*user_preferences*/
    			                if(!empty($preferences)){
    			                    $delete = $this->user_model->common_p_delete('user_preferences',array('user_type' => 'pal','user_type_id' => $pal_id));
    			                    
    			                    $pref = explode(',',$preferences);
    			                    foreach($pref as $f){
    			                        $dataf = array(
    			                            'user_type' => 'pal',
    			                            'user_type_id' => $pal_id,
    			                            'preference_id' => $f,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_preferences',$dataf);
    			                        
    			                    }
    			                }
    			                /*food*/
    			                if(!empty($foods)){
    			                    $delete = $this->user_model->common_p_delete('user_food',array('user_type' => 'pal','user_type_id' => $pal_id));
    			                    
    			                    $foo = explode(',',$foods);
    			                    foreach($foo as $o){
    			                        $datao = array(
    			                            'user_type' => 'pal',
    			                            'user_type_id' => $pal_id,
    			                            'food_id' => $o,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_food',$datao);
    			                        
    			                    }
    			                }
    			                /*activities*/
    			                if(!empty($activities)){
    			                    $delete = $this->user_model->common_p_delete('user_activities',array('user_type' => 'pal','user_type_id' => $pal_id));
    			                    $act = explode(',',$activities);
    			                    foreach($act as $a){
    			                        $dataa = array(
    			                            'user_type' => 'pal',
    			                            'user_type_id' => $pal_id,
    			                            'activity_id' => $a,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_activities',$dataa);
    			                        
    			                    }
    			                }
    			                
                    
                    $response = array('status' => true, 'message' => 'Pal Details updated successsfully', 'response' => array());
    				$this->response($response);
                    
                    
                    
                    
                    
                    
                }else{
                     $response = array('status' => false, 'message' => 'Pal ID is empty', 'response' => array());
    				$this->response($response);
                }
               	
    			 //       $response = array('status' => true, 'message' => 'Data Submitted Successfully', 'response' => array());
    				// $this->response($response);
            }
			
		}
	}
	/* update pal details */
	
	/* update par details */
    public function update_par_deatils_post()
     {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($par_id)){
            $response = array('status' => false, 'message' => 'Partner ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else if($check_user[0]['status'] == 0 || $check_user[0]['delete_status'] == 0){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
               // $user_update = $this->user_model->common_update('users',$data,array('id' => $user_id));
                
                if(!empty($email)){
                     $data = array(
    			       'email' => $email,
    			     //  'created_on' => date('Y-m-d H:i:s'),
    			       'updated_on' => date('Y-m-d H:i:s')
    			       );
                }else if(!empty($name) && !empty($dob)){
                     $data = array(
    			       'name' => $name,
    			       'dob'  => $dob,
    			   //    'created_on' => date('Y-m-d H:i:s'),
    			       'updated_on' => date('Y-m-d H:i:s')
    			       );
                }else if(!empty($gender)){
                     $data = array(
    			       'gender' => $gender,
    			   //    'created_on' => date('Y-m-d H:i:s'),
    			       'updated_on' => date('Y-m-d H:i:s')
    			       );
                }else if(!empty($from_city)){
                     $data = array(
    			       'from_city' => $from_city,
    			     //  'created_on' => date('Y-m-d H:i:s'),
    			       'updated_on' => date('Y-m-d H:i:s')
    			       );
                }else if(!empty($stay_city)){
                     $data = array(
    			       'stay_city' => $stay_city,
    			      // 'created_on' => date('Y-m-d H:i:s'),
    			       'updated_on' => date('Y-m-d H:i:s')
    			       );
                }else if(!empty($height_in_feet) || !empty($height_in_inches) || !empty($height_in_centimeters)){
                        $data = array(
                            'height_in_feet' => $height_in_feet,
                            'height_in_inches' => $height_in_inches,
                            'height_in_centimeters' => $height_in_centimeters,
                            'height_unit' => $height_unit,
                            'updated_on' => date('Y-m-d H:i:s')
                            );
                    }else if(!empty($religion)){
                        $data = array(
                            'religion' => $religion,
                            'updated_on' => date('Y-m-d H:i:s')
                            );
                    }else if(!empty($zodiac)){
                        $data = array(
                            'zodiac' => $zodiac,
                            'updated_on' => date('Y-m-d H:i:s')
                            );
                    }else{
                    $data = '';
                }
                if(!empty($data)){
                     $user_update = $this->user_model->common_update('users',$data,array('id' => $user_id));
    		
                }
                
                 /*languages */
    			                if(!empty($languages)){
                    $delete = $this->user_model->common_p_delete('user_languages',array('user_id' => $user_id));
    			                    $lan = explode(',',$languages);
    			                    foreach($lan as $l){
    			                        $datal = array(
    			                            'user_id' => $user_id,
    			                            'language_id' => $l,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_languages',$datal);
    			                        
    			                    }
    			                }
                
                
                
                if(!empty($par_id)){
                    
                    $fetchpar =   $this->user_model->common_fetch('par_registrations',array('id' => $par_id));
                  if(!empty($fetchpar) && empty($fetchpar[0]['created_on'])){
                      $this->user_model->common_update('par_registrations',array('created_on' => date('Y-m-d H:i:s')),array('id' => $par_id));
                  }
                  
                  
                    if(!empty($about)){
                        $data_pal = array(
                            'about' => $about,
                            'updated_on' => date('Y-m-d H:i:s')
                            );
                    }
                    // else if(!empty($height_in_feet) || !empty($height_in_inches) || !empty($height_in_centimeters)){
                    //     $data_pal = array(
                    //         'height_in_feet' => $height_in_feet,
                    //         'height_in_inches' => $height_in_inches,
                    //         'height_in_centimeters' => $height_in_centimeters,
                    //         'height_unit' => $height_unit,
                    //         'updated_on' => date('Y-m-d H:i:s')
                    //         );
                    // }
                    else if(!empty($designation)){
                        $data_pal = array(
                            'designation' => $designation,
                            'updated_on' => date('Y-m-d H:i:s')
                            );
                    }else if(!empty($workplace_institution)){
                        $data_pal = array(
                            'workplace_institution' => $workplace_institution,
                            'updated_on' => date('Y-m-d H:i:s')
                            );
                    }
                    // else if(!empty($religion)){
                    //     $data_pal = array(
                    //         'religion' => $religion,
                    //         'updated_on' => date('Y-m-d H:i:s')
                    //         );
                    // }else if(!empty($zodiac)){
                    //     $data_pal = array(
                    //         'zodiac' => $zodiac,
                    //         'updated_on' => date('Y-m-d H:i:s')
                    //         );
                    // }
                    else if(!empty($introvert_extravert_ambivort)){
                        $data_pal = array(
                            'introvert_extravert_ambivort' => $introvert_extravert_ambivort,
                            'updated_on' => date('Y-m-d H:i:s')
                            );
                    }else{
                        $data_pal = '';
                    }
                    if(!empty($data_pal)){
                        $user_update = $this->user_model->common_update('par_registrations',$data_pal,array('id' => $par_id));
                    }
                    
                    /*looking for*/
    			                if(!empty($looking_for)){
    			                    $delete = $this->user_model->common_p_delete('user_looking_for',array('user_type' => 'par','user_type_id' => $par_id));
    			                    $look = explode(',',$looking_for);
    			                    foreach($look as $l){
    			                        $datal = array(
    			                            'user_type' => 'par',
    			                            'user_type_id' => $par_id,
    			                            'looking_for_id' => $l,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_looking_for',$datal);
    			                        
    			                    }
    			                }
    			                /*intrestes*/
    			                if(!empty($interests)){
    			                    $delete = $this->user_model->common_p_delete('user_interests',array('user_type' => 'par','user_type_id' => $par_id));
    			                    $int = explode(',',$interests);
    			                    foreach($int as $i){
    			                        $datai = array(
    			                            'user_type' => 'par',
    			                            'user_type_id' => $par_id,
    			                            'interest_id' => $i,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_interests',$datai);
    			                        
    			                    }
    			                }
    			                 /*personality_traits*/
    			                if(!empty($personality_traits)){
    			                    $delete = $this->user_model->common_p_delete('user_personality_traits',array('user_type' => 'par','user_type_id' => $par_id));
    			                    $per = explode(',',$personality_traits);
    			                    foreach($per as $p){
    			                        $datap = array(
    			                            'user_type' => 'par',
    			                            'user_type_id' => $par_id,
    			                            'personality_traits_id' => $p,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_personality_traits',$datap);
    			                        
    			                    }
    			                }
    			                /*user_preferences*/
    			                if(!empty($preferences)){
    			                    $delete = $this->user_model->common_p_delete('user_preferences',array('user_type' => 'par','user_type_id' => $par_id));
    			                    
    			                    $pref = explode(',',$preferences);
    			                    foreach($pref as $f){
    			                        $dataf = array(
    			                            'user_type' => 'par',
    			                            'user_type_id' => $par_id,
    			                            'preference_id' => $f,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_preferences',$dataf);
    			                        
    			                    }
    			                }
    			                /*food*/
    			                if(!empty($foods)){
    			                    $delete = $this->user_model->common_p_delete('user_food',array('user_type' => 'par','user_type_id' => $par_id));
    			                    
    			                    $foo = explode(',',$foods);
    			                    foreach($foo as $o){
    			                        $datao = array(
    			                            'user_type' => 'par',
    			                            'user_type_id' => $par_id,
    			                            'food_id' => $o,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_food',$datao);
    			                        
    			                    }
    			                }
    			                /*activities*/
    			                if(!empty($activities)){
    			                    $delete = $this->user_model->common_p_delete('user_activities',array('user_type' => 'par','user_type_id' => $par_id));
    			                    $act = explode(',',$activities);
    			                    foreach($act as $a){
    			                        $dataa = array(
    			                            'user_type' => 'par',
    			                            'user_type_id' => $par_id,
    			                            'activity_id' => $a,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_activities',$dataa);
    			                        
    			                    }
    			                }
    			                
                    
                    $response = array('status' => true, 'message' => 'Partner Details updated successsfully', 'response' => array());
    				$this->response($response);
                    
                    
                    
                    
                    
                    
                }else{
                     $response = array('status' => false, 'message' => 'Pal ID is empty', 'response' => array());
    				$this->response($response);
                }
               	
    			 //       $response = array('status' => true, 'message' => 'Data Submitted Successfully', 'response' => array());
    				// $this->response($response);
            }
			
		}
	}
	/* update par details */
	/* update par details */
    public function update_pro_deatils_post()
     {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($pro_id)){
            $response = array('status' => false, 'message' => 'Professional Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else if($check_user[0]['status'] == 0 || $check_user[0]['delete_status'] == 0){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                
                if(!empty($email)){
                     $data = array(
    			       'email' => $email,
    			       'updated_on' => date('Y-m-d H:i:s')
    			       );
                }else if(!empty($name) && !empty($dob)){
                     $data = array(
    			       'name' => $name,
    			       'dob'  => $dob,
    			       'updated_on' => date('Y-m-d H:i:s')
    			       );
                }else if(!empty($gender)){
                     $data = array(
    			       'gender' => $gender,
    			       'updated_on' => date('Y-m-d H:i:s')
    			       );
                }else if(!empty($from_city)){
                     $data = array(
    			       'from_city' => $from_city,
    			       'updated_on' => date('Y-m-d H:i:s')
    			       );
                }else if(!empty($stay_city)){
                     $data = array(
    			       'stay_city' => $stay_city,
    			       'updated_on' => date('Y-m-d H:i:s')
    			       );
                }else if(!empty($height_in_feet) || !empty($height_in_inches) || !empty($height_in_centimeters)){
                        $data = array(
                            'height_in_feet' => $height_in_feet,
                            'height_in_inches' => $height_in_inches,
                            'height_in_centimeters' => $height_in_centimeters,
                            'height_unit' => $height_unit,
                            'updated_on' => date('Y-m-d H:i:s')
                            );
                    }else if(!empty($religion)){
                        $data = array(
                            'religion' => $religion,
                            'updated_on' => date('Y-m-d H:i:s')
                            );
                    }else if(!empty($zodiac)){
                        $data = array(
                            'zodiac' => $zodiac,
                            'updated_on' => date('Y-m-d H:i:s')
                            );
                    }else{
                    $data = '';
                }
                if(!empty($data)){
                     $user_update = $this->user_model->common_update('users',$data,array('id' => $user_id));
    		
                }
                
                
                 /*languages */
    			                if(!empty($languages)){
                    $delete = $this->user_model->common_p_delete('user_languages',array('user_id' => $user_id));
    			                    $lan = explode(',',$languages);
    			                    foreach($lan as $l){
    			                        $datal = array(
    			                            'user_id' => $user_id,
    			                            'language_id' => $l,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_languages',$datal);
    			                        
    			                    }
    			                }
                
                
                
                if(!empty($pro_id)){
                    
                    $fetchpro =   $this->user_model->common_fetch('pro_registrations',array('id' => $pro_id));
                  if(!empty($fetchpro) && empty($fetchpro[0]['created_on'])){
                      $this->user_model->common_update('pro_registrations',array('created_on' => date('Y-m-d H:i:s')),array('id' => $pro_id));
                  }
                  
                  
                    if(!empty($about)){
                        $data_pal = array(
                            'about' => $about,
                            'updated_on' => date('Y-m-d H:i:s')
                            );
                    }
                    // else if(!empty($height_in_feet) || !empty($height_in_inches) || !empty($height_in_centimeters)){
                    //     $data_pal = array(
                    //         'height_in_feet' => $height_in_feet,
                    //         'height_in_inches' => $height_in_inches,
                    //         'height_in_centimeters' => $height_in_centimeters,
                    //         'height_unit' => $height_unit,
                    //         'updated_on' => date('Y-m-d H:i:s')
                    //         );
                    //       // print_r($data_pal);exit;
                    // }
                    else if(!empty($title)){
                        $data_pal = array(
                            'title' => $title,
                            'updated_on' => date('Y-m-d H:i:s')
                            );
                    }else if(!empty($industry)){
                        $data_pal = array(
                            'industry' => $industry,
                            'updated_on' => date('Y-m-d H:i:s')
                            );
                    }else if(!empty($experience)){
                        $data_pal = array(
                            'experience' => $experience,
                            'updated_on' => date('Y-m-d H:i:s')
                            );
                    }else if(!empty($education)){
                        $data_pal = array(
                            'education' => $education,
                            'updated_on' => date('Y-m-d H:i:s')
                            );
                    }else if(!empty($location)){
                        $data_pal = array(
                            'location' => $location,
                            'updated_on' => date('Y-m-d H:i:s')
                            );
                    }else if(!empty($website)){
                        $data_pal = array(
                            'website' => $website,
                            'updated_on' => date('Y-m-d H:i:s')
                            );
                    }else{
                        $data_pal = '';
                    }
                    if(!empty($data_pal)){
                        $user_update = $this->user_model->common_update('pro_registrations',$data_pal,array('id' => $pro_id));
                    }
                   // echo $this->db->last_query();exit;
                    /*looking for*/
    			                if(!empty($looking_for)){
    			                    $delete = $this->user_model->common_p_delete('user_looking_for',array('user_type' => 'pro','user_type_id' => $pro_id));
    			                    $look = explode(',',$looking_for);
    			                    foreach($look as $l){
    			                        $datal = array(
    			                            'user_type' => 'pro',
    			                            'user_type_id' => $pro_id,
    			                            'looking_for_id' => $l,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_looking_for',$datal);
    			                        
    			                    }
    			                }
    			                /*intrestes*/
    			                if(!empty($interests)){
    			                    $delete = $this->user_model->common_p_delete('user_interests',array('user_type' => 'pro','user_type_id' => $pro_id));
    			                    $int = explode(',',$interests);
    			                    foreach($int as $i){
    			                        $datai = array(
    			                            'user_type' => 'pro',
    			                            'user_type_id' => $pro_id,
    			                            'interest_id' => $i,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_interests',$datai);
    			                        
    			                    }
    			                }
    			                 /*$achievements*/
    			                if(!empty($achievements)){
    			                    $delete = $this->user_model->common_p_delete('user_achievements',array('user_type' => 'pro','user_type_id' => $pro_id));
    			                    $per = explode(',',$achievements);
    			                    foreach($per as $p){
    			                        $datap = array(
    			                            'user_type' => 'pro',
    			                            'user_type_id' => $pro_id,
    			                            'achievement_id' => $p,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_achievements',$datap);
    			                        
    			                    }
    			                }
    			                
    			                 /*user_professional_connections*/
    			                if(!empty($professional_connections)){
    			                    $delete = $this->user_model->common_p_delete('user_professional_connections',array('user_type' => 'pro','user_type_id' => $pro_id));
    			                    $per = explode(',',$professional_connections);
    			                    foreach($per as $c){
    			                        $datac = array(
    			                            'user_type' => 'pro',
    			                            'user_type_id' => $pro_id,
    			                            'professional_connection_id' => $c,
    			                            'created_on' => date('Y-m-d H:i:s')
    			                            );
    			                            $this->user_model->common_insert('user_professional_connections',$datac);
    			                        
    			                    }
    			                }
    			                
                    
                    $response = array('status' => true, 'message' => 'Professional Details updated successsfully', 'response' => array());
    				$this->response($response);
                    
                    
                    
                    
                    
                    
                }else{
                     $response = array('status' => false, 'message' => 'Pal ID is empty', 'response' => array());
    				$this->response($response);
                }
               	
    			 //       $response = array('status' => true, 'message' => 'Data Submitted Successfully', 'response' => array());
    				// $this->response($response);
            }
			
		}
	}
	/* update pro details */
	
	public function delete_user_pic_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($image_id)){
            $response = array('status' => false, 'message' => 'Image ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => (object)array());
                $this->response($response);
            }else if($check_user[0]['status'] == 0 || $check_user[0]['delete_status'] == 0){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
               $get = $this->user_model->common_fetch('user_images',array('id' => $image_id));
               if(!empty($get[0]['image_link'])){
                   unlink($get[0]['image_link']);
                   $delete = $this->user_model->common_p_delete('user_images',array('id' => $image_id));
                   $response = array('status' => true, 'message' => 'Pics deleted successfully', 'response' => (object)array());
                $this->response($response);
               }
                
            }
        }
	}
	
	public function update_user_pic_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($user_type)){
            $response = array('status' => false, 'message' => 'User type Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($user_type_id)){
            $response = array('status' => false, 'message' => 'User type id Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($pic)){
            $response = array('status' => false, 'message' => 'Image  Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => (object)array());
                $this->response($response);
            }else if($check_user[0]['status'] == 0 || $check_user[0]['delete_status'] == 0){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                
                 /*user images*/
    			                if(!empty($pic)){
    			                    
    			                    
                               if(!empty($pic)){
                                   define('IMAGE_UPLOAD_DIR','assets/images/users_pics/');
                    				$img = str_replace('data:image/jpeg;base64','',$pic);
                    				$img = str_replace(' ','+',$img);
                    				$user_data = base64_decode($img);
                    				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
                    				$success = file_put_contents($user_file,$user_data); 
				
                    				if($success){
                    				   // $image_link = $user_file;
                    				//     unlink($get_child_detaiils[0]['father_image']);
                        				
                        				    $data1 = array(
                        						'user_type' => $user_type,
                        						'user_type_id' =>$user_type_id,
                        						'image_link' => $user_file,
                        						'created_on' => date('Y-m-d H:i:s')
                        						);
                        					 $this->user_model->common_insert('user_images',$data1);
                    				}
                               } 
                                    
    			                }
    			               
                   $response = array('status' => true, 'message' => 'Pics deleted successfully', 'response' => (object)array());
                $this->response($response);
               
                
            }
        }
	}
	
	public function check_user_in_zone_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($latitude)){
            $response = array('status' => false, 'message' => 'Latitude Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($longitude)){
            $response = array('status' => false, 'message' => 'Longitude Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else if($check_user[0]['status'] == 0 || $check_user[0]['delete_status'] == 0){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                if(!empty($check_user) && !empty($latitude) && !empty($longitude)){
                    $lat = $latitude;
                    $lng = $longitude;
                    //echo $lat;
                            $zone = $this->user_model->is_point_in_zone($lat, $lng);
                            //echo $this->db->last_query();
                            if(empty($zone)){
                                //You're not in a U-Zone! You can't connect outside of it. Check the location icon on the map to find U-Zones and start swiping
                                $response = array('status' => false, 'message' => "no data found", 'response' => array());
                $this->response($response);
               
                            }else{
                                $response = array('status' => true, 'message' => 'Zones fetched successfully', 'response' => $zone);
                $this->response($response);
                            }
                             
//echo json_encode($zone);exit;
                }else{
                               
                   $response = array('status' => false, 'message' => 'Your lacation details empty.Please update your location', 'response' => (object)array());
                    $this->response($response);
                }
                
            }
        }
	}
	
	public function view_events_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => (object)array());
                $this->response($response);
            }else if($check_user[0]['status'] == 0 || $check_user[0]['delete_status'] == 0){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			
    			       $events = $this->user_model->get_all_events($search_key);
    			       $feature = $this->user_model->get_all_featured_events($search_key);
    			       
    			        $response = array('status' => true, 'message' => 'Data Submitted Successfully', 'response' => 
    			        array('featured_events' => $feature,'all_events' => $events));
    				$this->response($response);
    			    
    				
    			
            }
			
		}
	}
	
	 /* view user modes */
    public function view_user_modes_post()
     {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else if($check_user[0]['status'] == 0 || $check_user[0]['delete_status'] == 0){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                
                if(empty($check_user[0]['player_id'])){
                    $data = array(
                        'player_id' => $player_id,
                        'updated_on' => date('Y-m-d H:i:s')
                        );
                 $this->user_model->common_update('users',$data,array('id' => $user_id));
                }
    			
    			   $get_planner = $this->user_model->user_all_modes($user_id);
    			//  echo $this->db->last_query();exit;
    			    if(empty($get_planner)){
    			        $response = array('status' => false, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
    			    }else{
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => $get_planner);
    				$this->response($response);
    			    }
    				
    			
            }
			
		}
	}
	/* view user modes */
	
	 /* user zone in out */
    public function user_zone_in_out_update_post()
     {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($type)){
            $response = array('status' => false, 'message' => 'Type Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($zone_id)){
            $response = array('status' => false, 'message' => 'Zone ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($mode)){
            $response = array('status' => false, 'message' => 'Mode Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => (object)array());
                $this->response($response);
            }else if($check_user[0]['status'] == 0 || $check_user[0]['delete_status'] == 0){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                 $check_in_zone = $this->user_model->common_fetch('user_in_zone',array('user_id' => $user_id,'status' => 'in'));
                  if($type == "in"){
                       $data = array(
                              'user_id' => $user_id,
                             // 'zone_id' => $zone_id,
                              'status' => 'in'
                              );
                         
                       $this->user_model->common_p_delete('user_in_zone',$data);
                      
                      
                     // if(empty($check_in_zone)){
                          $data = array(
                              'user_id' => $user_id,
                              'zone_id' => $zone_id,
                              'mode' => $mode,
                              'status' => 'in',
                              'created_on' => date('Y-m-d H:i:s'),
                              'updated_on' => date('Y-m-d H:i:s')
                              );
                              $insert = $this->user_model->common_insert('user_in_zone',$data);
                              
                                 $title = "U App";
            $message = "You are inside a Zone.";
            $user_type = '';
            $member_id = $check_user[0]['player_id'];
            $this->sendNotification_get($member_id,$title,$message,$user_type);//exit;
            
            
            
                              $response = array('status' => true, 'message' => 'You are in a zone', 'response' => (object)array());
    				          $this->response($response);
                     // }else{
                     //     $response = array('status' => false, 'message' => 'You are already in  a zone', 'response' => (object)array());
    				 //         $this->response($response);
                     // }
                      
                  }else if($type=="out"){
                      
                       $data1 = array(
                              'user_id' => $user_id,
                            //   'zone_id' => $zone_id, 
                            'status' => 'in'
                              );
                      $delete =  $this->user_model->common_p_delete('user_in_zone',$data1);
                      if($delete == true){
                          
            $title = "U App";
            $message = "You are out from a Zone.";
            $user_type = '';
            $member_id = $check_user[0]['player_id'];
            $this->sendNotification_get($member_id,$title,$message,$user_type);//exit;
            
                            $response = array('status' => true, 'message' => 'You are out from a zone', 'response' => (object)array());
    				          $this->response($response);
                      }else{
                            $response = array('status' => false, 'message' => 'error data', 'response' => (object)array());
    				          $this->response($response);
                      }
                       
                       
                    
                  }
                  else if($type == "update"){
                      $data = array(
                              //'user_id' => $user_id,
                             // 'zone_id' => $zone_id,
                              'mode' => $mode,
                           //   'status' => 'in',
                              'updated_on' => date('Y-m-d H:i:s')
                              );
                               $this->user_model->common_update('user_in_zone',$data,
                              array('user_id' => $user_id,'zone_id' => $zone_id,'status' => 'in'));
                               $response = array('status' => true, 'message' => 'Mode updated successfully', 'response' => (object)array());
    				          $this->response($response);
                  }else{
                      $response = array('status' => false, 'message' => 'Error data', 'response' => (object)array());
    				          $this->response($response);
                  }
    			
    			   	
    			
            }
			
		}
	}
	
	
	public function user_zone_out_post()
     {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($zone_id)){
            $response = array('status' => false, 'message' => 'Zone ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => (object)array());
                $this->response($response);
            }else if($check_user[0]['status'] == 0 || $check_user[0]['delete_status'] == 0){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                 $check_in_zone = $this->user_model->common_fetch('user_in_zone',array('user_id' => $user_id,'status' => 'in'));
                  // if($type=="out"){
                      
                       $data1 = array(
                              'user_id' => $user_id,
                            //   'zone_id' => $zone_id, 
                            'status' => 'in'
                              );
                      $delete =  $this->user_model->common_p_delete('user_in_zone',$data1);
                      if($delete == true){
                          
                          $this->user_model->common_p_delete('friend_requests',array('from_user_id' => $user_id, 'status' => 'request'));
                          $this->user_model->common_p_delete('friend_requests',array('to_user_id' => $user_id, 'status' => 'request'));
                          
                          $title = "U App";
            $message = "You are out from a Zone.";
            $user_type = '';
            $member_id = $check_user[0]['player_id'];
            $this->sendNotification_get($member_id,$title,$message,$user_type);//exit;
            
                            $response = array('status' => true, 'message' => 'You are out from a zone', 'response' => (object)array());
    				          $this->response($response);
                      }else{
                            $response = array('status' => false, 'message' => 'error data', 'response' => (object)array());
    				          $this->response($response);
                      }
                       
                       
                    
                //  }
               //   else{
                //      $response = array('status' => false, 'message' => 'Error data', 'response' => (object)array());
    			//	          $this->response($response);
               //   }
    			
    			   	
    			
            }
			
		}
	}
	/* user zone in out */
	
	
	 /*check user in a zone or not */
    public function check_user_zone_in_post()
     {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($lat)){
            $response = array('status' => false, 'message' => 'Latitude Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($zone_id)){
            $response = array('status' => false, 'message' => 'Zone ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($lon)){
            $response = array('status' => false, 'message' => 'Longitude Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else if($check_user[0]['status'] == 0 || $check_user[0]['delete_status'] == 0){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $check = $this->user_model->common_fetch('zones',array('status' => 1, 'delete_status' => 1,'id' => $zone_id));
                if(!empty($check)){
                      $in_zone = $this->user_model->is_user_in_zone($lat, $lon, $zone_id);
                      //echo "<pre>";
                      //echo $this->db->last_query();
                    //  print_r($in_zone);exit;
                  //  $in_zone = 1;
                        if ($in_zone) {
                            $data = array(
                                'updated_on' => date('Y-m-d H:i:s')
                                );
                                $this->user_model->common_update('user_in_zone',$data,array('user_id' => $user_id,'zone_id' => $zone_id));
   
                        $response = array('status' => true, 'message' => 'User is inside the zone.', 'response' => (object)array());
                        				          $this->response($response);
                    } else {
                       
                        $response = array('status' => false, 'message' => 'User is NOT inside the zone.', 'response' => (object)array());
                        				          $this->response($response);
                    }
                }else{
                     $response = array('status' => false, 'message' => 'User is NOT inside the zone.', 'response' => (object)array());
                        				          $this->response($response);
                }
               

                 
               

                 
                                                    
    			
    			   	
    			
            }
			
		}
	}
	/* check user in a zone or not */
	
	public function check_uninstall_inactive_users_get()
	{
	    $get_zone_in_users = $this->user_model->common_fetch('user_in_zone',array('status' => 'in'));
	   // echo "<pre>";
	   // print_r($get_zone_in_users);exit;
	    foreach($get_zone_in_users as $user){
	       $datetime1 =  $user['updated_on'];
	       $datetime2 =  date('Y-m-d H:i:s');
	        $minutes = (strtotime($datetime2) - strtotime($datetime1)) / 60;
	       // echo "<pre>";
//echo $minutes.'-'.$user['user_id'];
//echo "<pre>";
//exit;

	        if($minutes > 90){
	           // $data = array('new' => 1);
	          //  $this->user_model->common_update('user_in_zone',$data,array('user_id' => $user['user_id']));
	             $data1 = array(
                              'user_id' => $user['user_id']
                            //   'zone_id' => $zone_id, 
                          //  'status' => 'in'
                              );
                      $delete =  $this->user_model->common_p_delete('user_in_zone',$data1);
	        }
	    }//exit;
	}
	
	 public function user_current_zone_in_post()
     {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else if($check_user[0]['status'] == 0 || $check_user[0]['delete_status'] == 0){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                 $in_zone = $this->user_model->get_user_in_zone_details($user_id);

                 
                 if ($in_zone) {
   
                        $response = array('status' => true, 'message' => 'User is inside the zone.', 'response' => $in_zone);
                        				          $this->response($response);
                    } else {
                       
                        $response = array('status' => false, 'message' => 'User is NOT inside any zone.', 'response' => array());
                        				          $this->response($response);
                    }

                 
                                                    
    			
    			   	
    			
            }
			
		}
	}
	
	
	
	
	
	
	/* view subscriptions */
    public function view_all_subscriptions_post()
     {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else if($check_user[0]['status'] == 0 || $check_user[0]['delete_status'] == 0){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			$all = array();
    			$i = 0;
    			   $get_planner = $this->user_model->common_fetch('subscriptions',array('delete_status' => 1));
    			   foreach($get_planner as $ppp){
    			       $des = $this->user_model->common_fetch('sub_descriptions',array('sub_id' => $ppp['id']));
    			       if($check_user[0]['sub_id'] == $ppp['id']){
    			           $ppp['selected'] = "yes";
    			       }else{
    			           $ppp['selected'] = "no";
    			       }
    			       $ppp['description'] = $des;
    			       $all[$i] = $ppp;
    			       $i++;
    			   }
    			//  echo $this->db->last_query();exit;
    			    if(empty($get_planner)){
    			        $response = array('status' => false, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
    			    }else{
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => $all);
    				$this->response($response);
    			    }
    				
    			
            }
			
		}
	}
	/* view subscriptions */
	
	 /* add subscription */
    public function add_new_subscription_to_user_post()
     {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($sub_id)){
            $response = array('status' => false, 'message' => 'Subscription ID Empty', 'response' => (object)array());
            $this->response($response);
        }
        // else if(empty($sub_amount)){
        //     $response = array('status' => false, 'message' => 'Amount Is Empty', 'response' => (object)array());
        //     $this->response($response);
        // }
        else if(empty($transaction_id)){
            $response = array('status' => false, 'message' => 'Transaction ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else if($check_user[0]['status'] == 0 || $check_user[0]['delete_status'] == 0){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			
    			   $data = array(
    			       'sub_id' => $sub_id,
    			       'sub_amount' => $sub_amount,
    			       'sub_date' => date('Y-m-d H:i:s'),
    			       'transaction_id' => $transaction_id,
    			       'updated_on' => date('Y-m-d H:i:s')
    			       );
    			       $update = $this->user_model->common_update('users',$data,array('id' => $user_id));
    			       if($update){
    			           $datas = array(
    			               'user_id' => $user_id,
    			               'sub_id' => $sub_id,
            			       'sub_amount' => $sub_amount,
            			       'sub_date' => date('Y-m-d H:i:s'),
            			       'transaction_id' => $transaction_id,
            			       'sub_status' => 'active',
            			       'created_on' => date('Y-m-d H:i:s')
    			               );
    			               $this->user_model->common_insert('users_sub_history',$datas);
    			               
    			              
    			       }
    			       
    			        $title = "U App";
            $message = "Your new subscription added successfully.";
            $user_type = '';
            $member_id = $check_user[0]['player_id'];
            $this->sendNotification_get($member_id,$title,$message,$user_type);//exit;
    			       
    			     $response = array('status' => true, 'message' => 'Subscription Added Successfully', 'response' => array());
    				$this->response($response);
    			    
    				
    			
            }
			
		}
	}
	/* add subscription */
	
	/* view subscriptions */
    public function view_user_subscription_post()
     {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else if($check_user[0]['status'] == 0 || $check_user[0]['delete_status'] == 0){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			$all = array();
    			$i = 0;
    			if($check_user[0]['sub_id'] == 0){
    			    $response = array('status' => false, 'message' => 'No Subscription', 'response' => array());
    				$this->response($response);
    			}else{
    			    
    			
    			   $get_planner = $this->user_model->common_fetch('subscriptions',array('id' => $check_user[0]['sub_id']));
    			   foreach($get_planner as $ppp){
    			       $des = $this->user_model->common_fetch('sub_descriptions',array('sub_id' => $ppp['id']));
    			       $ppp['description'] = $des;
    			       $all[$i] = $ppp;
    			       $i++;
    			   }
    		    	//  echo $this->db->last_query();exit;
    			    if(empty($get_planner)){
    			        $response = array('status' => false, 'message' => 'Empty Data', 'response' => array());
    				$this->response($response);
    			    }else{
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => $all);
    				$this->response($response);
    			    }
    			}
    				
    			
            }
			
		}
	}
	/* view subscriptions */
	
	/* view all zones */
    public function view_all_zones_post()
     {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else if($check_user[0]['status'] == 0 || $check_user[0]['delete_status'] == 0){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			
    			   //$get_planner = $this->user_model->get_all_zones_with_sample_point(); 
    			   $get_planner = $this->user_model->get_all_zones_with_centroid();
    			    ///echo $this->db->last_query();exit;
    			    if(empty($get_planner)){
    			        $response = array('status' => false, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
    			    }else{
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => $get_planner);
    				$this->response($response);
    			    }
    				
    			
            }
			
		}
	}
	/* view all zones */
	
	public function view_in_zone_members_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($zone_id)){
            $response = array('status' => false, 'message' => 'Zone ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else if($check_user[0]['status'] == 0 || $check_user[0]['delete_status'] == 0){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                if($check_user[0]['sub_id'] == 0 ){ //|| $check_user[0]['sub_id'] == 5
                    $response = array('status' => false, 'message' => 'No Subscription for user', 'response' => array());
                    $this->response($response);
                }else{
                    
                
                
    			    $all = array();
    		    	$i = 0;
    			   $get_planner = $this->user_model->get_inzone_user_details($user_id,$zone_id,$mode,$gender);
    			   foreach($get_planner as $ppp){
    			       if($ppp['mode'] == 'pal'){
    			           $des = $this->user_model->get_pal_profile_pic($ppp['user_id']);
    			       }else if($ppp['mode'] == 'par'){
    			           $des = $this->user_model->get_par_profile_pic($ppp['user_id']); 
    			       }else if($ppp['mode'] == 'pro'){
    			           $des = $this->user_model->get_pro_profile_pic($ppp['user_id']);
    			       }
    			       if($des[0]['image_link'] == NULL){
    			           $ppp['profile_pic'] = "";
    			       }else{
    			           $ppp['profile_pic'] = $des[0]['image_link'];
    			       }
    			       
    			        //  echo "<pre>";
    			//  echo $this->db->last_query();
    		//	  print_r($des);exit;
    			
    			       
    			       
    			       $all[$i] = $ppp;
    			       $i++;
    			   }
    			   //  echo $this->db->last_query();exit;
    			    if(empty($get_planner)){
    			        $response = array('status' => false, 'message' => 'Empty Data', 'response' => array());
    				$this->response($response);
    			    }else{
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => $all);
    				$this->response($response);
    			    }
                }
    				
    			
            }
			
		}
	}
	
	/* view in zone user profile */
    public function view_in_zone_user_profile_post()
     {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($member_id)){
            $response = array('status' => false, 'message' => 'Member ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($member_mode)){
            $response = array('status' => false, 'message' => 'Member mode Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else if($check_user[0]['status'] == 0 || $check_user[0]['delete_status'] == 0){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			
    			   $user = $this->user_model->get_user_details_all($member_id);
            $get_languages = $this->user_model->get_user_languages($member_id);
            $user[0]['all_languages'] = $get_languages;
            
             if($member_mode == "pal"){
                 $get = $this->user_model->get_pal_details_all($member_id);
                $get[0]['looking_for'] = $looking = $this->user_model->get_all_looking_fors_user($get[0]['user_type_id'],"pal");
                $get[0]['interests'] = $looking = $this->user_model->get_all_interests_user($get[0]['user_type_id'],"pal");
                $get[0]['personality_traits'] = $looking = $this->user_model->get_all_personality_traits_user($get[0]['user_type_id'],"pal");
                $get[0]['preferences'] = $looking = $this->user_model->get_all_preferences_user($get[0]['user_type_id'],"pal");
                $get[0]['foods'] = $looking = $this->user_model->get_all_foods_user($get[0]['user_type_id'],"pal");
                $get[0]['activities'] = $looking = $this->user_model->get_all_activities_user($get[0]['user_type_id'],"pal");
                $get[0]['achievements']  = array();
                $get[0]['professional_connections']  = array();
                 $pics = $this->user_model->common_fetch('user_images',array('user_type' => 'pal', 'user_type_id' => $get[0]['user_type_id']));
                 
             }else if($member_mode == "par"){
                 $get = $this->user_model->get_par_details_all($member_id);
                 $get[0]['looking_for'] = $looking = $this->user_model->get_all_looking_fors_user($get[0]['user_type_id'],"par");
                 $get[0]['interests'] = $looking = $this->user_model->get_all_interests_user($get[0]['user_type_id'],"par");
                 $get[0]['personality_traits'] = $looking = $this->user_model->get_all_personality_traits_user($get[0]['user_type_id'],"par");
                 $get[0]['preferences'] = $looking = $this->user_model->get_all_preferences_user($get[0]['user_type_id'],"par");
                 $get[0]['foods'] = $looking = $this->user_model->get_all_foods_user($get[0]['user_type_id'],"par");
                 $get[0]['activities'] = $looking = $this->user_model->get_all_activities_user($get[0]['user_type_id'],"par");
                 $get[0]['achievements']  = array();
                 $get[0]['professional_connections']  = array();
                 $pics = $this->user_model->common_fetch('user_images',array('user_type' => 'par', 'user_type_id' => $get[0]['user_type_id']));
                 
             }else if($member_mode == "pro"){
                 $get = $this->user_model->get_pro_details_all($member_id);
                 $pro = $this->user_model->common_fetch('pro_registrations',array('user_id' => $member_id));
                 $get[0]['about'] = $pro[0]['about'];
                 $get[0]['user_id'] = $member_id;
                // $get[0]['religion_name'] = '';
                // $get[0]['height_in_feet'] = '';
                // $get[0]['height_in_inches'] = '';
               //  $get[0]['height_in_centimeters'] = '';
                 //$get[0]['height_unit'] = '';
                 $get[0]['designation'] = '';
                 $get[0]['workplace_institution'] = '';
                // $get[0]['zodiac'] = '';
                 $get[0]['introvert_extravert_ambivort'] = '';
                 $get[0]['looking_for'] = $this->user_model->get_all_looking_fors_user($get[0]['user_type_id'],"pro");
                 $get[0]['interests'] = $this->user_model->get_all_interests_user($get[0]['user_type_id'],"pro");
                 $get[0]['personality_traits'] = array();
                 $get[0]['preferences'] = array();
                 $get[0]['foods'] = array();
                 $get[0]['activities'] = array();
                 $get[0]['achievements']  = $this->user_model->get_all_achievements_user($get[0]['user_type_id'],"pro");
                 $get[0]['professional_connections']  = $this->user_model->get_all_professional_connections_user($get[0]['user_type_id'],"pro");
                 $pics = $this->user_model->common_fetch('user_images',array('user_type' => 'pro', 'user_type_id' => $get[0]['user_type_id']));
                 
             }else{
                 $response = array('status' => false, 'message' => 'User Type Is Invalid', 'response' => (object)array());
            $this->response($response);
             }
             if(!empty($user) && !empty($get)){
                 $all =  array_merge($user[0],$get[0]);
            $all['pics'] = $pics;
             $request_status = $this->check_friend_status($user_id,$member_id);
             
             $get_request = $this->user_model->common_fetch('friend_requests',array('from_user_id' => $member_id  , 'to_user_id' => $user_id));
    		$all['friendship_status'] = $request_status;
    		if(!empty($get_request)){
    		    $all['request_id'] = $get_request[0]['id'];
    		}else{
    		    $all['request_id'] = '';
    		}
    		
    		$all['verified_status'] = "no";
    	
             }else{
                 $response = array('status' => false, 'message' => 'No data', 'response' => (object)array());
    				$this->response($response);
             }
           			$response = array('status' => true, 'message' => 'User Profile Details', 'response' => $all);
    				$this->response($response);	
    			
            }
			
		}
	}
	/* view in zone user profile */
	
	    // GET /api/check_friend_status?user1=1&user2=2
    public function check_friend_status($user1,$user2) {
       // $user1 = $this->input->get('user1');
       // $user2 = $this->input->get('user2');


        $this->db->where(" (from_user_id = $user1 AND to_user_id = $user2) 
                        OR (from_user_id = $user2 AND to_user_id = $user1) ");
        $request = $this->db->get('friend_requests')->row();

        if ($request) {
            if ($request->status === 'accepted') {
                $status = 'friends';
            } elseif ($request->from_user_id == $user1) {
                $status = 'pending_sent';
            } else {
                $status = 'pending_received';
            }
        } else {
            $status = 'not_friends';
        }
    return $status;
        // $this->output
        //      ->set_content_type('application/json')
        //      ->set_output(json_encode([
        //          'status' => true,
        //          'relationship_status' => $status
        //      ]));
    }

	
	/* send friend request  */
    public function send_friend_request_post()
     {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($friend_user_id)){
            $response = array('status' => false, 'message' => 'Friend user ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($friend_mode)){
            $response = array('status' => false, 'message' => 'Friend Mode Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else if($check_user[0]['status'] == 0 || $check_user[0]['delete_status'] == 0){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			
    			   $data = array(
    			       'from_user_id' => $user_id,
    			       'to_user_id' => $friend_user_id,
    			       'from_user_mode' => $user_mode,
    			       'to_user_mode' => $friend_mode,
    			       'status' => 'request',
    			       'created_on' => date('Y-m-d H:i:s')
    			       );
    			       $insert = $this->user_model->common_insert('friend_requests',$data);
    			       
    			     $new_f =  $this->user_model->common_fetch('users',array('id' => $friend_user_id));
    			       $title = "U App";
            $message = "Your got a new connection request.";
            $user_type = '';
            $member_id = $new_f[0]['player_id'];
            $this->sendNotification_get($member_id,$title,$message,$user_type);//exit;
            
    			        $response = array('status' => true, 'message' => 'Data Submitted Successfully', 'response' => array());
    				$this->response($response);
    			    
    				
    			
            }
			
		}
	}
	/* sent friend request */
	
	/* view all my requests */
    public function view_all_my_requests_post()
     {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else if($check_user[0]['status'] == 0 || $check_user[0]['delete_status'] == 0){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			$get_all_requests = $this->user_model->get_all_my_requests($user_id,$filter);
    			if(!empty($get_all_requests)){
    			    $all = [];
    			    $i = 0;
    			    foreach($get_all_requests as $by_me){
    			        if($by_me['from_user_mode'] == 'pal'){
    			           $des = $this->user_model->get_pal_profile_pic($by_me['from_user_id']);
    			           if(!empty($des)){
    			               $picnew = trim($des[0]['image_link']);
    			           }else{
    			               $picnew = trim("");
    			           }
    			           
    			       }else if($by_me['from_user_mode'] == 'par'){
    			           $des = $this->user_model->get_par_profile_pic($by_me['from_user_id']);
    			           if(!empty($des)){
    			               $picnew = trim($des[0]['image_link']);
    			           }else{
    			               $picnew = trim("");
    			           }
    			       }else if($by_me['from_user_mode'] == 'pro'){
    			           $des = $this->user_model->get_pro_profile_pic($by_me['from_user_id']);
    			           if(!empty($des)){
    			               $picnew = trim($des[0]['image_link']);
    			           }else{
    			               $picnew = trim("");
    			           }
    			       }else{
    			          // $des[0]['image_link'] = '';
    			          $picnew = trim("");
    			       }
    			      // echo "<pre>";
    			      // echo $picnew;exit;
    			      // print_r($des);exit;
    			       
    			       $by_me['profile_pic'] = $picnew;
    			       $all[$i] = $by_me;
    			       $i++;
    			    }
    			}
    			 // echo $this->db->last_query();exit;
    			    if(empty($all)){
    			        $response = array('status' => false, 'message' => 'Empty Data', 'response' => array());
    				$this->response($response);
    			    }else{
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => $all);
    				$this->response($response);
    			    }
    				
    			
            }
			
		}
	}
	/* view all my requests */
	
	
	/* view all friends list */
    public function view_all_chats_list_post()
     {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else if($check_user[0]['status'] == 0 || $check_user[0]['delete_status'] == 0){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			$get_all_requests_by_me = $this->user_model->friend_request_sent_by_me($user_id,$filter);
    			$all  = [];
    			if(!empty($get_all_requests_by_me)){
    			   // print_r($get_all_requests_by_me);
     			    $all = [];
    			    $i = 0;
    			    foreach($get_all_requests_by_me as $by_me){
    			      
    			        if($by_me['to_user_mode'] == 'pal'){
    			           $des = $this->user_model->get_pal_profile_pic($by_me['to_user_id']);
    			       }else if($by_me['to_user_mode'] == 'par'){
    			            // echo "hi";exit;
    			           $des = $this->user_model->get_par_profile_pic($by_me['to_user_id']);
    			          
    			       }else if($by_me['to_user_mode'] == 'pro'){
    			           $des = $this->user_model->get_pro_profile_pic($by_me['to_user_id']);
    			       }
    			      // echo $this->db->last_query();
    			      // print_r($des);exit;
    			      if(!empty($des[0])){
    			          $by_me['profile_pic'] = $des[0]['image_link'];
    			      }else{
    			          $by_me['profile_pic'] = "";
    			      }
    			       
    			       $all[$i] = $by_me;
    			       $i++;
    			    }
    			}
    			$get_all_requests_to_me = $this->user_model->friend_request_sent_to_me($user_id,$filter);
    			$all_to  = [];
    			if(!empty($get_all_requests_to_me)){
    			    $all_to  = [];
    			    $j = 0;
    			    foreach($get_all_requests_to_me as $to_me){
    			        if($to_me['from_user_mode'] == 'pal'){
    			           $des = $this->user_model->get_pal_profile_pic($to_me['from_user_id']);
    			       }else if($to_me['from_user_mode'] == 'par'){
    			           $des = $this->user_model->get_par_profile_pic($to_me['from_user_id']);
    			       }else if($to_me['from_user_mode'] == 'pro'){
    			           $des = $this->user_model->get_pro_profile_pic($to_me['from_user_id']);
    			       }
    			        
    			       $to_me['profile_pic'] = $des[0]['image_link'];
    			       $all_to[$j] = $to_me;
    			       $j++;
    			    }
    			}
    			
    		//	echo "<pre>";
    		//	print_r($all_to);exit;
    			if(empty($get_all_requests_by_me) && empty($get_all_requests_to_me)){
    			    $response = array('status' => false, 'message' => 'Empty Data', 'response' => array());
    				$this->response($response);
    			}else{
    			    $friends = array_merge($all, $all_to);

    			}
    			//  echo $this->db->last_query();exit;
    			    
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => $friends);
    				    $this->response($response);
    			    
    				
    			
            }
			
		}
	}
	/* view all  friends list */
	
	public function accept_reject_request_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($request_id)){
            $response = array('status' => false, 'message' => 'Request ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($type)){
            $response = array('status' => false, 'message' => 'Type Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else if($check_user[0]['status'] == 0 || $check_user[0]['delete_status'] == 0){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                if($type == "accept"){
                    $data = array(
    			       'status' => "accepted",
    			       'updated_on' => date('Y-m-d H:i:s')
    			       );
    			       $update = $this->user_model->common_update('friend_requests',$data,array('id' => $request_id));
    			       $req = $this->user_model->common_fetch('friend_requests',array('id' => $request_id));
    			        $new_f =  $this->user_model->common_fetch('users',array('id' => $req[0]['from_user_id']));
    			       $title = "U App";
            $message = "Your connection request accepted.";
            $user_type = '';
            $member_id = $new_f[0]['player_id'];
            $this->sendNotification_get($member_id,$title,$message,$user_type);//exit;
            
    			       $response = array('status' => true, 'message' => 'Request Accepted Successfully', 'response' => array());
    				$this->response($response);
    			    
                    
                }else if($type == "reject"){
                     $req = $this->user_model->common_fetch('friend_requests',array('id' => $request_id));
                    $data = array(
    			       'status' => "rejected",
    			       'updated_on' => date('Y-m-d H:i:s')
    			       );
    			       $delete = $this->user_model->common_p_delete('friend_requests',array('id' => $request_id));
    			       
    			        $new_f =  $this->user_model->common_fetch('users',array('id' => $req[0]['from_user_id']));
    			       $title = "U App";
            $message = "Your connection request rejected.";
            $user_type = '';
            $member_id = $new_f[0]['player_id'];
            $this->sendNotification_get($member_id,$title,$message,$user_type);//exit;
            
    			       $response = array('status' => true, 'message' => 'Request Rejected Successfully', 'response' => array());
    				$this->response($response);
    			    
                    
                }else{
                    $response = array('status' => false, 'message' => 'Invalid Type', 'response' => array());
                $this->response($response);
                }
    			
    			        
    				
    			
            }
			
		}
	}
	
	/* delete account */
    public function delete_account_post()
     {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else if($check_user[0]['status'] == 0 || $check_user[0]['delete_status'] == 0){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			
    			   $data = array(
    			       'delete_status' => 0,
    			       'updated_on' => date('Y-m-d H:i:s')
    			       );
    			       $update = $this->user_model->common_update('users',$data,array('id' => $user_id));
    			       $this->user_model->common_p_delete('users',array('id' => $user_id));
    			       $this->user_model->common_p_delete('user_in_zone',array('user_id' => $user_id));
    			       $this->user_model->common_p_delete('friend_requests',array('from_user_id' => $user_id));
    			       $this->user_model->common_p_delete('friend_requests',array('to_user_id' => $user_id));
    			       $this->user_model->common_p_delete('user_languages',array('user_id' => $user_id));
    			       /* pal details delete */
    			       $pal = $this->user_model->common_fetch('pal_registrations',array('user_id' => $user_id));
    			       if(!empty($pal)){
    			           $images = $this->user_model->common_fetch('user_images',array('user_type_id' => $pal[0]['id'],'user_type' => 'pal'));
    			           foreach($images as $img){
    			               unlink($img['image_link']);
    			               $this->user_model->common_p_delete('user_images',array('id' => $img['id'])); 
    			           }
    			           $this->user_model->common_p_delete('user_food',array('user_type_id' => $pal[0]['id'],'user_type' => 'pal'));
    			           $this->user_model->common_p_delete('user_interests',array('user_type_id' => $pal[0]['id'],'user_type' => 'pal'));
    			           $this->user_model->common_p_delete('user_activities',array('user_type_id' => $pal[0]['id'],'user_type' => 'pal'));
    			           $this->user_model->common_p_delete('user_looking_for',array('user_type_id' => $pal[0]['id'],'user_type' => 'pal'));
    			           $this->user_model->common_p_delete('user_personality_traits',array('user_type_id' => $pal[0]['id'],'user_type' => 'pal'));
    			           $this->user_model->common_p_delete('user_preferences',array('user_type_id' => $pal[0]['id'],'user_type' => 'pal'));
    			           
    			           
    			       }
    			       $this->user_model->common_p_delete('pal_registrations',array('user_id' => $user_id));
    			       /* pal details delete */
    			        /* partner details delete */
    			       $par = $this->user_model->common_fetch('par_registrations',array('user_id' => $user_id));
    			       if(!empty($par)){
    			           $images = $this->user_model->common_fetch('user_images',array('user_type_id' => $par[0]['id'],'user_type' => 'par'));
    			           foreach($images as $img){
    			               unlink($img['image_link']);
    			               $this->user_model->common_p_delete('user_images',array('id' => $img['id']));
    			           }
    			           $this->user_model->common_p_delete('user_food',array('user_type_id' => $par[0]['id'],'user_type' => 'par'));
    			           $this->user_model->common_p_delete('user_interests',array('user_type_id' => $par[0]['id'],'user_type' => 'par'));
    			           $this->user_model->common_p_delete('user_activities',array('user_type_id' => $par[0]['id'],'user_type' => 'par'));
    			           $this->user_model->common_p_delete('user_looking_for',array('user_type_id' => $par[0]['id'],'user_type' => 'par'));
    			           $this->user_model->common_p_delete('user_personality_traits',array('user_type_id' => $par[0]['id'],'user_type' => 'par'));
    			           $this->user_model->common_p_delete('user_preferences',array('user_type_id' => $par[0]['id'],'user_type' => 'par'));
    			       }
    			       $this->user_model->common_p_delete('par_registrations',array('user_id' => $user_id));
    			       /* partner details delete */
    			       /* profession details delete */
    			       $pro = $this->user_model->common_fetch('pro_registrations',array('user_id' => $user_id));
    			       if(!empty($pro)){
    			           $images = $this->user_model->common_fetch('user_images',array('user_type_id' => $pro[0]['id'],'user_type' => 'pro'));
    			           foreach($images as $img){
    			               unlink($img['image_link']);
    			               $this->user_model->common_p_delete('user_images',array('id' => $img['id']));
    			           }
    			           $this->user_model->common_p_delete('user_interests',array('user_type_id' => $pro[0]['id'],'user_type' => 'pro'));
    			           $this->user_model->common_p_delete('user_achievements',array('user_type_id' => $pro[0]['id'],'user_type' => 'pro'));
    			           $this->user_model->common_p_delete('user_looking_for',array('user_type_id' => $pro[0]['id'],'user_type' => 'pro'));
    			           $this->user_model->common_p_delete('user_professional_connections',array('user_type_id' => $pro[0]['id'],'user_type' => 'pro'));
    			       }
    			       $this->user_model->common_p_delete('pro_registrations',array('user_id' => $user_id));
    			       /* profession details delete */
    			       
    			        $response = array('status' => true, 'message' => 'Account Deleted Successfully', 'response' => array());
    				$this->response($response);
    			    
    				
    			
            }
			
		}
	}
	/* delete account */
	
	 /* block user */
    public function block_user_post()
     {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($type)){
            $response = array('status' => false, 'message' => 'Name Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($blocked_id)){
            $response = array('status' => false, 'message' => 'Email ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else if($check_user[0]['status'] == 0 || $check_user[0]['delete_status'] == 0){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			$block_check1 = $this->user_model->common_fetch('blocked_users',array('blocked_user_id' => $user_id, 'blocked_by_user_id' => $blocked_id));
    			$block_check2 = $this->user_model->common_fetch('blocked_users',array('blocked_user_id' => $blocked_id, 'blocked_by_user_id' => $user_id));
    			if(empty($block_check1) && empty($block_check2)){
    			     $data = array(
    			       'blocked_user_id' => $blocked_id,
    			       'type' => $type,
    			       'blocked_by_user_id' => $user_id,
    			       'created_on' => date('Y-m-d H:i:s')
    			       );
    			       $insert = $this->user_model->common_insert('blocked_users',$data);
    			        $response = array('status' => true, 'message' => 'Data Submitted Successfully', 'response' => array());
    				$this->response($response);
    			}else{
    			    $response = array('status' => false, 'message' => 'User already blocked by you or user blocked you.', 'response' => array());
    				$this->response($response);
    			}
    			  
    			       
    			    
    				
    			
            }
			
		}
	}
	/* block user */
	
	 /* un friend user */
    public function unfriend_user_post()
     {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($friend_id)){
            $response = array('status' => false, 'message' => 'Name Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else if($check_user[0]['status'] == 0 || $check_user[0]['delete_status'] == 0){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			
    			       $this->user_model->common_p_delete('friend_requests',array('from_user_id' => $user_id, 'to_user_id' => $friend_id));
    			       $this->user_model->common_p_delete('friend_requests',array('to_user_id' => $user_id, 'from_user_id' => $friend_id));
    			        $response = array('status' => true, 'message' => 'Un Friend Successfully', 'response' => array());
    				$this->response($response);
    			    
            }
			
		}
	}
	/* un friend user */
	
	
	
	
	
	
	
	 /* contact us */
    public function contact_us_post()
     {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($name)){
            $response = array('status' => false, 'message' => 'Name Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($email)){
            $response = array('status' => false, 'message' => 'Email ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($message)){
            $response = array('status' => false, 'message' => 'Message Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else if($check_user[0]['status'] == 0 || $check_user[0]['delete_status'] == 0){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			
    			   $data = array(
    			       'user_id' => $user_id,
    			       'name' => $name,
    			       'email' => $email,
    			       'mobile' => $mobile,
    			       'message' => $message,
    			       'created_on' => date('Y-m-d H:i:s')
    			       );
    			       $insert = $this->user_model->common_insert('contact_us_details',$data);
    			        $response = array('status' => true, 'message' => 'Data Submitted Successfully', 'response' => array());
    				$this->response($response);
    			    
    				
    			
            }
			
		}
	}
	/* conatct us */
	
	
	 /* view about us details */
    public function view_about_us_post()
     {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else if($check_user[0]['status'] == 0 || $check_user[0]['delete_status'] == 0){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			
    			   $get_planner = $this->user_model->common_fetch('about_us',array('id' => 1));
    			//  echo $this->db->last_query();exit;
    			    if(empty($get_planner)){
    			        $response = array('status' => false, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
    			    }else{
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => $get_planner);
    				$this->response($response);
    			    }
    				
    			
            }
			
		}
	}
	/* view about us details */
	
	
	 /* view about us details */
    public function view_child_safety_get()
     {
         		   $get_planner = $this->user_model->common_fetch('child_safety_standard',array('id' => 1));
         		   echo $get_planner[0]['content'];
    			//  echo $this->db->last_query();exit;
    			 //   if(empty($get_planner)){
    			 //       $response = array('status' => false, 'message' => 'Empty Data', 'response' => (object)array());
    				// $this->response($response);
    			 //   }else{
    			 //       $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => $get_planner);
    				// $this->response($response);
    			 //   }
    				
    			
            
			
		
	}
	/* view about us details */
	
	
	
	
	/* view terms and conditions details */
    public function view_terms_and_conditions_post()
     {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else if($check_user[0]['status'] == 0 || $check_user[0]['delete_status'] == 0){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			
    			   $get_planner = $this->user_model->common_fetch('terms_and_conditons',array('id' => 1));
    			//  echo $this->db->last_query();exit;
    			    if(empty($get_planner)){
    			        $response = array('status' => false, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
    			    }else{
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => $get_planner);
    				$this->response($response);
    			    }
    				
    			
            }
			
		}
	}
	/* view terms and conditions details */
	/* view privacy policy details */
    public function view_privacy_policy_post()
     {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else if($check_user[0]['status'] == 0 || $check_user[0]['delete_status'] == 0){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			  if($type == "return"){
    			      $get_planner = $this->user_model->common_fetch('return_and_refund_policy',array('id' => 1));
    			  }else if($type == "cookies"){
    			      $get_planner = $this->user_model->common_fetch('cookies_policy',array('id' => 1));
    			  }else{
    			      $get_planner = $this->user_model->common_fetch('privacy_policy',array('id' => 1));
    			  }
    			   
    			//  echo $this->db->last_query();exit;
    			    if(empty($get_planner)){
    			        $response = array('status' => false, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
    			    }else{
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => $get_planner);
    				$this->response($response);
    			    }
    				
    			
            }
			
		}
	}
	/* view privacy policy details */
	
	
	/* view hottest & near by zones */
    public function view_hottest_and_nearby_zones_post()
     {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($user_lat)){
            $response = array('status' => false, 'message' => 'Latitude Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($user_lon)){
            $response = array('status' => false, 'message' => 'Longitude Token Is Empty', 'response' => array());
            $this->response($response);
        }
        // else if(empty($city_name)){
        //     $response = array('status' => false, 'message' => 'City Name Is Empty', 'response' => array());
        //     $this->response($response);
        // }
        else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else if($check_user[0]['status'] == 0 || $check_user[0]['delete_status'] == 0){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			$radius = 20; // e.g., 10 km radius
    			   $nearby_zones = $this->user_model->get_nearby_zones($user_lat, $user_lon, $radius);
    			  // echo $this->db->last_query();exit;
    			  // $city_name = "";
    		//	   $city = $this->user_model->common_fetch('cities',array('LOWER(city_name)' => strtolower($city_name)));
    		$city = $this->user_model->common_fetch('cities',array('id' => $check_user[0]['stay_city']));
    			   if(!empty($city)){
    			       $city_id = $city[0]['id'];
    			   }else{
    			       $city_id = '';
    			   }
    			  // echo $city_id;
    			    $get_planner = $this->user_model->get_all_hottest_zones_with_centroid($city_id);

    			//  echo $this->db->last_query();exit;
    			    if(empty($get_planner) && empty($nearby_zones)){
    			        $response = array('status' => false, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
    			    }else{
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => 
    			        array('hottest_zones' => $get_planner,'nearby_zones' => $nearby_zones));
    				$this->response($response);
    			    }
    				
    			
            }
			
		}
	}
	/* view hottest and near by zones */
	
	
	/* user images */
	public function user_all_images_post()
	{
	    $user_input = $this->client_request;
    extract($user_input);

    if (empty($user_id)) {
        $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
        $this->response($response);
    } elseif (empty($auth_token)) {
        $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
        $this->response($response);
    } else {
        $check_user = $this->user_model->common_fetch('users', array('id' => $user_id));

        if ($check_user[0]['auth_token'] != $auth_token) {
            $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
            $this->response($response);
        } else {
           $pal =  $this->user_model->common_fetch('pal_registrations', array('user_id' => $user_id));
           if(!empty($pal)){
            $pics = $this->user_model->common_fetch('user_images',array('user_type' => 'pal', 'user_type_id' => $pal[0]['id']));
           }else{
              $pics = []; 
           }
           
           $par =  $this->user_model->common_fetch('par_registrations', array('user_id' => $user_id));
           if(!empty($par)){
            $pics2 = $this->user_model->common_fetch('user_images',array('user_type' => 'par', 'user_type_id' => $par[0]['id']));
           }else{
              $pics2 = []; 
           }
           
           $pro =  $this->user_model->common_fetch('pro_registrations', array('user_id' => $user_id));
           if(!empty($pro)){
            $pics3 = $this->user_model->common_fetch('user_images',array('user_type' => 'pro', 'user_type_id' => $pro[0]['id']));
           }else{
              $pics3 = []; 
           }
           
          // $pics = is_array($pics) ? $pics : [];
         //  $pics2 = is_array($pics2) ? $pics2 : [];
         //  $pics3 = is_array($pics3) ? $pics3 : [];
           $merged = array_merge($pics, $pics2, $pics3);
           
           $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => $merged);
    				$this->response($response);


        }
    }
	    
	}
	
	/* user images */
	
	
	/* generate twilio token for user */
   public function get_user_token_post() {
    $user_input = $this->client_request;
    extract($user_input);

    if (empty($user_id)) {
        $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
        $this->response($response);
    } elseif (empty($auth_token)) {
        $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
        $this->response($response);
    } else {
        $check_user = $this->user_model->common_fetch('users', array('id' => $user_id));

        if ($check_user[0]['auth_token'] != $auth_token) {
            $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
            $this->response($response);
        } else {
            // ✅ Fix here: == instead of =
            if ($type == "voice") {
                $get_token = $this->generate_voice_token_post($user_id);
            } else {
                $get_token = $this->generate_token($user_id); // Assume this is for chat or other cases
                
                
            }

            if (empty($get_token)) {
                $response = array('status' => false, 'message' => 'Empty Data', 'response' => (object)array());
            } else {
                $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('token' => $get_token));
            }

            $this->response($response);
        }
    }
}


     public function get_user_voice_token_post() {
    $user_input = $this->client_request;
    extract($user_input);

    if (empty($user_id)) {
        $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
        $this->response($response);
    } elseif (empty($auth_token)) {
        $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
        $this->response($response);
    } else {
        $check_user = $this->user_model->common_fetch('users', array('id' => $user_id));

        if ($check_user[0]['auth_token'] != $auth_token) {
            $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
            $this->response($response);
        } else {
                $get_token = $this->generate_voice_token_new_post($user_id);
           
            if (empty($get_token)) {
                $response = array('status' => false, 'message' => 'Empty Data', 'response' => (object)array());
            } else {
                $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('token' => $get_token));
            }

            $this->response($response);
        }
    }
}

	/* generate twilio token for user*/
	
	
   
    public function send_user_notification_post() {
    $user_input = $this->client_request;
    extract($user_input);

    if (empty($user_id)) {
        $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
        $this->response($response);
    } elseif (empty($auth_token)) {
        $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
        $this->response($response);
    } else {
        $check_user = $this->user_model->common_fetch('users', array('id' => $user_id));

        if ($check_user[0]['auth_token'] != $auth_token) {
            $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
            $this->response($response);
        } else {
            // ✅ Fix here: == instead of =
            $title = "Hello User";
            $message = "Welcome to U App ";
            $user_type = '';
            $member_id = $check_user[0]['player_id'];
            $this->sendNotification_get($member_id,$title,$message,$user_type);//exit;
            
                $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array());
            

            $this->response($response);
        }
    }
}

// public function voice_handler_post()
// {
//     $user_input = $this->client_request;
//     extract($user_input);

//     if (empty($user_id)) {
//         $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
//         $this->response($response);
//     }else{
        
//       //  require_once 'vendor/autoload.php';

// $response = new VoiceResponse();
// $to = $user_id ?? '';

// if (preg_match('/^[\d\+]+$/', $to)) {
//     // Dial a real phone number
//     $response->dial($to, ['callerId' => '+17067072929']);
// } else {
//     // Dial a client identity (e.g., user_123)
//     $dial = $response->dial(['callerId' => '+17067072929']);
//     $dial->client($to);
// }

// header('Content-Type: text/xml');
// echo $response;


    
    
    
    
//     }
// }


public function voice_handler_post()
{
    $user_input = $this->client_request;
    extract($user_input);

    if (empty($user_id)) {
        $response = array(
            'status' => false,
            'message' => 'User ID is empty',
            'response' => (object)[]
        );
        $this->response($response);
    } else {
        // Load Twilio SDK
        require_once APPPATH . 'third_party/Twilio/autoload.php';

        // Use the Twilio VoiceResponse class
      //  use Twilio\TwiML\VoiceResponse;

        // Create TwiML response
        $response = new VoiceResponse();

        // Format the user_id to a valid client identity (e.g., user_5)
        $clientIdentity = "user_" . $user_id;

        // Create <Dial> with attributes, then add <Client>
        $dial = $response->dial(null, ['callerId' => '+17067072929']); // ✅ Correct format
        $dial->client($clientIdentity);

        // Return TwiML XML response
        header('Content-Type: text/xml');
        echo $response;
        exit;
    }
}


public function to_receiver_call_post()
{
    $user_input = $this->client_request;
    extract($user_input);

    if (empty($from_user_id)) {
        $response = array('status' => false, 'message' => 'From User ID Is Empty', 'response' => (object)array());
        $this->response($response);
    }else if (empty($to_user_id)) {
        $response = array('status' => false, 'message' => 'To User ID Is Empty', 'response' => (object)array());
        $this->response($response);
    }else if (empty($from_user_id_mode)) {
        $response = array('status' => false, 'message' => 'From User ID Mode Is Empty', 'response' => (object)array());
        $this->response($response);
    }else if (empty($to_user_id_mode)) {
        $response = array('status' => false, 'message' => 'To User ID Mode Is Empty', 'response' => (object)array());
        $this->response($response);
    }else{ 
        $message = [];
        if(!empty($from_user_id)){
        	   $user = $this->user_model->get_user_details_all($from_user_id);
             if($from_user_id_mode == "pal"){
                 $get = $this->user_model->get_pal_details_all($from_user_id);
                 $pics = $this->user_model->common_fetch('user_images',array('user_type' => 'pal', 'user_type_id' => $get[0]['id']));
                 
             }else if($from_user_id_mode == "par"){
                 $get = $this->user_model->get_par_details_all($from_user_id);
                 $pics = $this->user_model->common_fetch('user_images',array('user_type' => 'par', 'user_type_id' => $get[0]['id']));
                 
             }else if($from_user_id_mode == "pro"){
                 $get = $this->user_model->get_pro_details_all($from_user_id);
                 $pics = $this->user_model->common_fetch('user_images',array('user_type' => 'pro', 'user_type_id' => $get[0]['id']));
                 
             }else{
                 $response = array('status' => false, 'message' => 'User Type Is Invalid', 'response' => (object)array());
            $this->response($response);
             }
             
             $message['from_user_id'] = $from_user_id;
             $message['from_user_name'] = $user[0]['name'];
             $message['from_user_mobile'] = $user[0]['mobile'];
             $message['from_user_pic'] = $pics[0]['image_link'];
            
        }
             
             
        if(!empty($to_user_id)){
        	   $user = $this->user_model->get_user_details_all($to_user_id);
             if($to_user_id_mode == "pal"){
                 $get = $this->user_model->get_pal_details_all($to_user_id);
                 $pics = $this->user_model->common_fetch('user_images',array('user_type' => 'pal', 'user_type_id' => $get[0]['id']));
                 
             }else if($to_user_id_mode == "par"){
                 $get = $this->user_model->get_par_details_all($to_user_id);
                 $pics = $this->user_model->common_fetch('user_images',array('user_type' => 'par', 'user_type_id' => $get[0]['id']));
                 
             }else if($to_user_id_mode == "pro"){
                 $get = $this->user_model->get_pro_details_all($to_user_id);
                 $pics = $this->user_model->common_fetch('user_images',array('user_type' => 'pro', 'user_type_id' => $get[0]['id']));
                 
             }else{
                 $response = array('status' => false, 'message' => 'User Type Is Invalid', 'response' => (object)array());
            $this->response($response);
             }
             $get_token = $this->generate_voice_token_post($to_user_id);
             
             $message['to_user_id'] = $to_user_id;
             $message['to_user_name'] = $user[0]['name'];
             $message['to_user_mobile'] = $user[0]['mobile'];
             $message['to_user_pic'] = $pics[0]['image_link'];
             $message['to_user_voice_token'] = $get_token;
             $playerId = $user[0]['player_id'];
            
        }
        //echo "<pre>";
          $this->sendNotificationtest_voice_get($message,$playerId);
      
      $title = "Hello User";
            $message = "Welcome to U App ";
            $user_type = '';
            $member_id = $user[0]['player_id'];
            $this->sendNotification_get($member_id,$title,$message,$user_type);exit;
      
        $response = array('status' => true, 'message' => 'Notification sent successfully', 'response' => (object)array());
            $this->response($response);
             
    }
}

public function sendNotificationtest_voice_get($message,$playerId){
    $appId = '34866b81-82c4-4fec-b39a-95f9ac395de3'; // Replace with your OneSignal App ID
    $apiKey = 'os_v2_app_gsdgxamcyrh6zm42sx42yok54obloqi5dslu435fykdqdy4euwql2se25hapqag2ie7uv34tgji6ln5ez4v37skb7vw3l2el736enli'; // Replace with your OneSignal REST API Key
     
    
    $segments = ['All'];
    $curl = curl_init();
    
   // echo $playerId;exit;
    
    //$playerId = 'eef050b4-5ce4-4e75-81d2-a588157bed85';

    $notificationData = [
        "app_id" => $appId,
        //"included_segments" => $segments, // Target specific segments
        "include_player_ids" => [$playerId], // Target a specific device (player ID)
        "data" => [
            "key1"              => "value1",
            "key2"              => "value2",
            'status'            => "call",
            'type'             => "voice",
            'from_user_id'             => $message['from_user_id'],
            'from_user_name'       => $message['from_user_name'],
            'from_user_mobile'         => $message['from_user_mobile'],
            'from_user_pic'         => $message['from_user_pic'],
            'to_user_id'           => $message['to_user_id'],
            'to_user_name'           => $message['to_user_name'],
            'to_user_mobile'          => $message['to_user_mobile'],
            'to_user_pic'        => $message['to_user_pic'],
            'to_user_voice_token' => $message['to_user_voice_token'],
            'player_id'         => $playerId,
            
        ],
        "content_available" =>  true,
        "android_background_data" => true,
        "priority" => 10,
    ];
    
   // echo "<pre>";
    //print_r($notificationData);

    curl_setopt_array($curl, [
        CURLOPT_URL => "https://onesignal.com/api/v1/notifications",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => json_encode($notificationData),
        CURLOPT_HTTPHEADER => [
            "Authorization: Key $apiKey", // API Key in Authorization header
            "Content-Type: application/json"
        ],
        CURLOPT_SSL_VERIFYPEER => false, // Disable SSL verification for debugging
    ]);

    $response = curl_exec($curl);
    $err = curl_error($curl);

    curl_close($curl);

    // if ($err) {
    //     echo "cURL Error #:" . $err;
    // } else {
    //     echo $response;
    // }
}


public function sendNotification_one_signal_get($playerId, $title, $message, $user_type = null) {
    $appId = '34866b81-82c4-4fec-b39a-95f9ac395de3'; // Replace with your OneSignal App ID
    $apiKey = 'os_v2_app_gsdgxamcyrh6zm42sx42yok54obloqi5dslu435fykdqdy4euwql2se25hapqag2ie7uv34tgji6ln5ez4v37skb7vw3l2el736enli'; // Replace with your OneSignal REST API Key
    
    $curl = curl_init();

    // Common notification data
    $notificationData = [
        "app_id" => $appId,
        "headings" => ["en" => $title], // Notification title
        "contents" => ["en" => $message], // Notification content
        "small_icon" => "no_bg_logo", // Android Small Icon (Place inside res/drawable),
    ];

    // 1️⃣ *Sending to ALL Users*
    if ($playerId === 'all') {
        //$notificationData["included_segments"] = ["All"]; // Send to all users
        $notificationData["filters"] = [
            ["field" => "tag", "key" => "user_type", "relation" => "=", "value" => $user_type]
        ];
    
    // 2️⃣ *Sending to a Filtered User Type (e.g., Only Employees or Only Users)*
    } /*elseif ($userType !== null) {
        
    
    // 3️⃣ *Sending to Multiple Specific Users*
    }*/ elseif (is_array($playerId)) {
        $notificationData["include_player_ids"] = $playerId; // Send to multiple users
    
    // 4️⃣ *Sending to a Single User*
    } else {
        $notificationData["include_player_ids"] = [$playerId]; // Send to a single user
    }

    curl_setopt_array($curl, [
        CURLOPT_URL => "https://onesignal.com/api/v1/notifications",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => json_encode($notificationData),
        CURLOPT_HTTPHEADER => [
            "Authorization: Key $apiKey", // API Key in Authorization header
            "Content-Type: application/json"
        ],
        CURLOPT_SSL_VERIFYPEER => false, // Disable SSL verification for debugging
    ]);

    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);

    if ($err) {
        return "cURL Error: " . $err;
    } else {
        return  $response;
    }
}


	
	
	
	
	
	
	
	
	
	
	
	
	

     public function send_mail_get()
     {
           $this->load->config('email');
        $this->load->library('email');
            
            // $config['protocol']    = 'smtp';
            // $config['smtp_host']    = 'ssl://smtp.gmail.com';
            // $config['smtp_port']    = '465';
            // $config['smtp_timeout'] = '7';
            // $config['smtp_user']    = 'sagarnalluri22@gmail.com';
            // $config['smtp_pass']    = '';
            // $config['charset']    = 'utf-8';
            // $config['newline']    = "\r\n";
            // $config['mailtype'] = 'text'; // or html
            // $config['validation'] = TRUE; // bool whether to validate email or not      
            
            // $this->email->initialize($config);
            
            // $this->email->from('sagarnalluri22@gmail.com', 'sender_name');
            // $this->email->to('sagarnalluri22@gmail.com'); 
            // $this->email->subject('Email Test');
            // $this->email->message('Testing the email class.');  
            
            // $this->email->send();
           // $this->email->initialize($config);
            $from = 'sagarnalluri22@gmail.com';
            $to = 'sagarnalluri22@gmail.com';
            $subject = 'test';
            $message = 'test';
             $this->email->set_newline("\r\n");
        $this->email->from($from);
        $this->email->to($to);
        $this->email->subject($subject);
        $this->email->message($message);

        if ($this->email->send()) {
            echo 'Your Email has successfully been sent.';
        } else {
            show_error($this->email->print_debugger());
        }
             
            echo $this->email->print_debugger();
            exit;
            $response = array('status' => true, 'message' => 'Email Sent Successfully', 'response' => $mail);
                   $this->response($response);
            
     }
     
     
     
     
	 /*user location update */
	public function view_update_ios_version_post()
    {
        $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($type)){
            $response = array('status' => false, 'message' => 'Latitude Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($version)){
            $response = array('status' => false, 'message' => 'Longitude Is Empty', 'response' => (object)array());
            $this->response($response);
        }
        // else if(empty($address)){
        //     $response = array('status' => false, 'message' => 'Address Is Empty', 'response' => (object)array());
        //     $this->response($response);
        // }
        else{
            if($type == "view"){
              $user_version =   $this->user_model->common_fetch('users',array('id' => $user_id));
               $app_version =  $this->user_model->common_fetch('ios_app_version',array('id' => 1));
               
               $response = array('status' => true, 'message' => 'Version Details  Fetched Successfully', 'response' => 
               array( 'user_version' => $user_version[0]['app_version'], 
                      'app_version' => $app_version[0]['version'], 
                      'status' => $app_version[0]['status']));
    				$this->response($response);
                 
            }else{
    			$data = array(
    			    'app_version' => $version,
    			    'updated_on' => date('Y-m-d H:i:s')
    			    );
    			    $this->user_model->common_update('users',$data,array('id' => $user_id));
    			//echo $this->db->last_query();exit;
    			   	$response = array('status' => true, 'message' => 'Version Details  Updated Successfully', 'response' => (object)array());
    				$this->response($response);
            }
            
			
		}
    }
	/*user location update */
	
	

}

?>