<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Twilio_model extends CI_Model {

    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    // Use this single function to keep identity format centralized
    public function format_identity($user_id_or_username)
    {
        // Default format: user_{id}
        // If you prefer usernames or email, adapt this function.
        if (is_numeric($user_id_or_username)) {
            return 'user_' . $user_id_or_username;
        }
        // sanitize input for Twilio identity allowed chars
        $id = preg_replace('/[^a-zA-Z0-9_\-\.\@]/', '_', $user_id_or_username);
        return $id;
    }

    public function save_twilio_mapping($app_user_id, $identity)
    {
        $data = [
            'app_user_id' => $app_user_id,
            'twilio_identity' => $identity,
            'created_at' => date('Y-m-d H:i:s')
        ];
        return $this->db->insert('user_twilio_mapping', $data);
    }

    public function get_identity_by_user($app_user_id)
    {
        return $this->db->select('twilio_identity')->from('user_twilio_mapping')
                        ->where('app_user_id', $app_user_id)->get()->row_array();
    }

    public function save_conversation($conversation_sid, $user1, $user2)
    {
        $data = [
            'conversation_sid' => $conversation_sid,
            'user1' => $user1,
            'user2' => $user2,
            'created_at' => date('Y-m-d H:i:s')
        ];
        return $this->db->insert('twilio_conversations', $data);
    }
}