<?php
defined('BASEPATH') OR exit('No direct script access allowed');

// If you use Composer, make sure autoload is available (optional)
 require_once FCPATH . 'vendor/autoload.php';

use Twilio\Jwt\AccessToken;
use Twilio\Jwt\Grants\ChatGrant;
use Twilio\Jwt\Grants\VideoGrant;
use Twilio\Rest\Client;

class TwilioController extends CI_Controller {

    private $twAccountSid;
    private $twApiKeySid;
    private $twApiKeySecret;
    private $twChatServiceSid; // Conversations / Chat Service SID

    public function __construct()
    {
        parent::__construct();
        $this->load->model('api/Twilio_model');
        $this->load->helper('url');
        $this->load->library('session');

        // ---------- PLACEHOLDERS - Replace with your Twilio credentials ----------
        $this->twAccountSid    = 'AC9853dd687a28436d1c2b658de5988262';
        $this->twApiKeySid     = 'SK39ffefd46f81a4d629149de5266df78d';
        $this->twApiKeySecret  = 'RP9dtjYBlsrQN33s42YKjbBcDK7peBRe';
        $this->twChatServiceSid = 'IS7d684fd80b6c4a18ad0689bb01515fb2';
        // -------------------------------------------------------------------------
    }

    // Simple health check
    public function index()
    {
        echo json_encode(['status' => true, 'message' => 'TwilioController up']);
    }

    // Generate Chat (Conversations) access token
    public function chat_token()
    {
        $user_id = $this->input->get_post('user_id');
        if (!$user_id) {
            return $this->output
                        ->set_status_header(400)
                        ->set_content_type('application/json')
                        ->set_output(json_encode(['status' => false, 'message' => 'user_id required']));
        }

        $identity = $this->Twilio_model->format_identity($user_id);

        $ttl = intval($this->input->get_post('ttl')) ?: 3600; // seconds

        // Create access token
        $token = new AccessToken(
            $this->twAccountSid,
            $this->twApiKeySid,
            $this->twApiKeySecret,
            $ttl,
            $identity
        );

        $chatGrant = new ChatGrant();
        $chatGrant->setServiceSid($this->twChatServiceSid);
        $token->addGrant($chatGrant);

        $jwt = $token->toJWT();

        $this->output
             ->set_content_type('application/json')
             ->set_output(json_encode(['status' => true, 'token' => $jwt, 'identity' => $identity]));
    }

    // Generate Video token (Programmable Video)
    public function video_token()
    {
        $user_id = $this->input->get_post('user_id');
        $room = $this->input->get_post('room') ?: null; // optional room name
        if (!$user_id) {
            return $this->output
                        ->set_status_header(400)
                        ->set_content_type('application/json')
                        ->set_output(json_encode(['status' => false, 'message' => 'user_id required']));
        }

        $identity = $this->Twilio_model->format_identity($user_id);
        $ttl = intval($this->input->get_post('ttl')) ?: 3600;

        $token = new AccessToken(
            $this->twAccountSid,
            $this->twApiKeySid,
            $this->twApiKeySecret,
            $ttl,
            $identity
        );

        $videoGrant = new VideoGrant();
        if ($room) {
            $videoGrant->setRoom($room);
        }
        $token->addGrant($videoGrant);

        $this->output
             ->set_content_type('application/json')
             ->set_output(json_encode(['status' => true, 'token' => $token->toJWT(), 'identity' => $identity, 'room' => $room]));
    }

    // Create conversation (Conversations API) — optional: requires REST Client
    public function create_conversation()
    {
        $user1 = $this->input->post('user1');
        $user2 = $this->input->post('user2');

        if (!$user1 || !$user2) {
            return $this->output
                        ->set_status_header(400)
                        ->set_content_type('application/json')
                        ->set_output(json_encode(['status' => false, 'message' => 'user1 and user2 required']));
        }

        try {
            $client = new Client($this->twAccountSid, $this->twApiKeySecret);

            // Create conversation via Conversations API
            $conversation = $client->conversations->v1->conversations
                               ->create([ 'friendlyName' => "conv_{$user1}_{$user2}_" . time() ]);

            // Add participants (identities created on mobile using access token)
            $identity1 = $this->Twilio_model->format_identity($user1);
            $identity2 = $this->Twilio_model->format_identity($user2);

            $client->conversations->v1->conversations($conversation->sid)
                   ->participants
                   ->create(['identity' => $identity1]);

            $client->conversations->v1->conversations($conversation->sid)
                   ->participants
                   ->create(['identity' => $identity2]);

            // Save mapping in DB (optional)
            $this->Twilio_model->save_conversation($conversation->sid, $user1, $user2);

            $this->output->set_content_type('application/json')
                 ->set_output(json_encode(['status' => true, 'conversation_sid' => $conversation->sid]));

        } catch (Exception $e) {
            $this->output->set_status_header(500)
                 ->set_content_type('application/json')
                 ->set_output(json_encode(['status' => false, 'message' => $e->getMessage()]));
        }
    }

    // Create Video Room server-side (optional)
    public function create_room()
    {
        $roomName = $this->input->post('room');
        if (!$roomName) {
            return $this->output
                        ->set_status_header(400)
                        ->set_content_type('application/json')
                        ->set_output(json_encode(['status' => false, 'message' => 'room required']));
        }

        try {
            $client = new Client($this->twAccountSid, $this->twApiKeySecret);
            $room = $client->video->v1->rooms->create([ 'uniqueName' => $roomName, 'type' => 'group' ]);

            $this->output->set_content_type('application/json')
                 ->set_output(json_encode(['status' => true, 'room_sid' => $room->sid, 'unique_name' => $room->uniqueName]));
        } catch (Exception $e) {
            $this->output->set_status_header(500)
                 ->set_content_type('application/json')
                 ->set_output(json_encode(['status' => false, 'message' => $e->getMessage()]));
        }
    }

}